/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpBroadcastClassifier;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectRouter {
    private static final int OBJECT_RETRY_RETENTION = 1;
    private static final Logger LOG = LoggerFactory.getLogger(ObjectRouter.class);
    private Map<Class, ObjectHandler> handlerMap = new ConcurrentHashMap<Class, ObjectHandler>();
    private BroadcastListenerHandlerForClass broadcastHandler;
    private MapperHandler mappers;
    private AmqpBroadcastClassifier amqpBroadcastClassifier;
    protected LinkedBlockingDeque<WaitingObject> retryObjects = new LinkedBlockingDeque();

    public ObjectRouter(BroadcastListenerHandlerForClass broadcastHandler, MapperHandler mappers, AmqpBroadcastClassifier amqpBroadcastClassifier) {
        this.broadcastHandler = broadcastHandler;
        this.mappers = mappers;
        this.amqpBroadcastClassifier = amqpBroadcastClassifier;
    }

    public <T> void addHandler(Class<T> clazz, ObjectHandler<T> handler) {
        this.handlerMap.put(clazz, handler);
    }

    public <T> void handleObject(Session session, T object, String correlationId) {
        if (object == null) {
            LOG.warn("cannot handle null object");
            return;
        }
        this.doHandleObject(session, object, correlationId);
        if (!this.retryObjects.isEmpty()) {
            this.retryHandleObject(session, object);
        }
    }

    public void addRetryObject(Object object, String correlationId) {
        LOG.info("Will try processing {} later {}", (Object)object.getClass(), (Object)correlationId);
        this.retryObjects.add(new WaitingObject(this, object, correlationId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void retryHandleObject(Session session, T object) {
        Iterator<WaitingObject> li = this.retryObjects.iterator();
        while (li.hasNext()) {
            WaitingObject waitingObject = li.next();
            if (this.amqpBroadcastClassifier.getWaitForReport(waitingObject.getObject().getClass()).equals(object.getClass())) {
                try {
                    LOG.info("Retrying to handle {}", (Object)waitingObject);
                    this.doHandleObject(session, waitingObject.getObject(), waitingObject.getCorrelationId());
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("", e);
                    continue;
                }
                finally {
                    li.remove();
                    continue;
                }
            }
            if (!waitingObject.getDateTimeCreated().isBefore(DateTime.now().minusMinutes(1))) continue;
            LOG.info("Cleanup, removing {}: {}", (Object)waitingObject, waitingObject.getObject());
            li.remove();
        }
    }

    private <T> void doHandleObject(Session session, T object, String correlationId) {
        ObjectHandler handler = this.handlerMap.get(object.getClass());
        if (handler == null) {
            BroadcastEntity translated = this.mappers.translate(BroadcastEntity.class, object, correlationId);
            if (translated != null) {
                this.broadcastHandler.notifyListeners(translated);
            } else {
                LOG.error("no object handler for objects of type {} ", (Object)object.getClass());
            }
            return;
        }
        handler.handleObject(session, object, correlationId);
    }

    protected LinkedBlockingDeque<WaitingObject> getRetryObjects() {
        return this.retryObjects;
    }

    private class WaitingObject {
        private final Object object;
        private final String correlationId;
        private final DateTime dateTimeCreated;

        public WaitingObject(@Nonnull ObjectRouter objectRouter, Object object, String correlationId) {
            this.object = object;
            this.correlationId = correlationId;
            this.dateTimeCreated = DateTime.now();
        }

        public Object getObject() {
            return this.object;
        }

        public String getCorrelationId() {
            return this.correlationId;
        }

        public DateTime getDateTimeCreated() {
            return this.dateTimeCreated;
        }

        public String toString() {
            return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("object", this.object.getClass()).append("correlationId", this.correlationId).append("dateTimeCreated", this.dateTimeCreated).toString();
        }
    }
}

