/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.common;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.AbstractColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ExportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.util.Util;

public abstract class NamedTypeImportColumn<C extends Enum, E>
extends AbstractColumn<C>
implements ExportColumn<C, E> {
    public NamedTypeImportColumn(String header, Class<C> valueClass) {
        super(header, valueClass);
    }

    @Override
    public String getStringValue(C value) {
        return ((DisplayName)value).getDisplayName();
    }

    protected C parseNamedTypeValue(String data) throws ImportException {
        if (data == null || data.isEmpty()) {
            return null;
        }
        for (Enum c : (Enum[])this.getValueClass().getEnumConstants()) {
            if (!((DisplayName)((Object)c)).getDisplayName().equalsIgnoreCase(data)) continue;
            return (C)c;
        }
        throw new ImportException("Wrong value " + data + " provided for column " + this.getHeader(), Util.getLabel("importException_invalidValue", data, this.getHeader()));
    }
}

