/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.BalancingGroupQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.AbstractColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ExportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class OrderBalancingGroupColumn
extends AbstractColumn<BalancingGroup>
implements ImportColumn<BalancingGroup, Order>,
ExportColumn<BalancingGroup, Order> {
    private final BalancingGroupQueries balancingGroupQueries;
    private final UserService userService;

    public OrderBalancingGroupColumn(String header, ApplicationContext applicationContext) {
        super(header, BalancingGroup.class);
        this.userService = applicationContext.getService(UserService.class);
        this.balancingGroupQueries = applicationContext.getService(BalancingGroupQueries.class);
    }

    @Override
    public void applyValue(BalancingGroup value, Order importedObject) {
        importedObject.setBalancingGroup(value);
    }

    @Override
    public BalancingGroup parseValue(String data) throws ImportException {
        List<BalancingGroup> balancingGroupsByName = this.balancingGroupQueries.findByName(data).getAll().toList();
        if (balancingGroupsByName.isEmpty()) {
            if (data != null && !data.isEmpty()) {
                throw new ImportException("Invalid BG name", Util.getLabel("importException_invalidBalancingGroup"));
            }
            return null;
        }
        if (balancingGroupsByName.size() > 1) {
            throw new ImportException("Multiple BGs for one name", Util.getLabel("importException_invalidBalancingGroup"));
        }
        BalancingGroup bg = balancingGroupsByName.get(0);
        User user = this.userService.getCurrentUser();
        boolean isAssignedToBg = user.containsBalancingGroupId((String)bg.getId());
        if (!isAssignedToBg) {
            throw new ImportException("Invalid BG name", Util.getLabel("importException_invalidBalancingGroup"));
        }
        return bg;
    }

    @Override
    public String getStringValue(BalancingGroup value) {
        return value.getName();
    }

    @Override
    public BalancingGroup getValue(Order objectToExport) {
        return objectToExport.getBalancingGroup();
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Arrays.asList(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_BG.getMessageKey());
    }
}

