/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.StringColumn;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import java.util.Arrays;
import java.util.Collection;

public class OrderContractReferenceColumn
extends StringColumn<Order>
implements ImportColumn<String, Order> {
    public OrderContractReferenceColumn(String header) {
        super(header);
    }

    @Override
    public void applyValue(String value, Order importedObject) {
        importedObject.setContractReference(value);
    }

    @Override
    public String parseValue(String data) throws ImportException {
        return this.parseStringValue(data);
    }

    @Override
    public String getValue(Order objectToExport) {
        return objectToExport.getContractReference();
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Arrays.asList(ValidationMessage.ORDER_VALIDATION_ERROR_CONTRACT_REFERENCE_TOO_LONG.getMessageKey(), ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_CONTRACT_REFERENCE.getMessageKey());
    }
}

