/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.listener;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.type.SpecialMessage;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.TradeRecallRequestedMessageEvent;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.EnumSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@Singleton
public class MessagePopupListener {
    private final UserAlertService userAlertService;
    private final UserService userService;
    private final ApplicationConfigurationService applicationConfigurationService;
    private final TradingSettingsService tradingSettingsService;
    private final BackendConnectionGateway backendConnectionGateway;
    private final EventBus eventBus;
    private boolean showingPopups;
    private final ScheduledExecutorService scheduledExecutorService;
    private AtomicBoolean recallMessagesScheduled = new AtomicBoolean(false);
    private BlockingQueue<SpecialMessage> recallMessageQueue = new LinkedBlockingQueue<SpecialMessage>();
    private static final EnumSet<SpecialMessage> POPUP_TRIGGERS_ADMIN = EnumSet.of(SpecialMessage.FIRST_LOGIN_AFTER_CONNECTION_LOSS, SpecialMessage.TRADE_RECALL_ACCEPTED, SpecialMessage.TRADE_RECALL_REQUESTED, SpecialMessage.TRADE_RECALL_REQUESTED_ON_BEHALF, SpecialMessage.TRADE_RECALL_REJECTED_NO_CAPACITY);
    private static final EnumSet<SpecialMessage> POPUP_TRIGGERS_TRADER = EnumSet.of(SpecialMessage.FIRST_LOGIN_AFTER_CONNECTION_LOSS, new SpecialMessage[]{SpecialMessage.TRADE_CANCELLED, SpecialMessage.TRADE_RECALL_ACCEPTED, SpecialMessage.TRADE_RECALL_REQUESTED, SpecialMessage.TRADE_RECALL_REQUESTED_ON_BEHALF, SpecialMessage.TRADE_RECALL_REJECTED_NO_CAPACITY});
    private static final EnumSet<SpecialMessage> GROUP_RECALL_POPUP_TRIGGERS = EnumSet.of(SpecialMessage.TRADE_RECALL_REJECTED_DELIVERY_TOO_CLOSE, SpecialMessage.TRADE_RECALL_REJECTED_EXECUTION_TOO_LONG);

    @Inject
    public MessagePopupListener(ApplicationContext applicationContext, UserAlertService userAlertService, ApplicationConfigurationService applicationConfigurationService, UserService userService, EventBus eventBus) {
        this.userAlertService = userAlertService;
        this.userService = userService;
        this.applicationConfigurationService = applicationConfigurationService;
        this.tradingSettingsService = applicationContext.getService(TradingSettingsService.class);
        this.backendConnectionGateway = applicationContext.getService(BackendConnectionGateway.class);
        this.eventBus = eventBus;
        eventBus.register(this);
        applicationContext.getSmallDataModel(Message.class).registerListener(new AbstractDataModelListener<Message>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(Message object) {
                return MessagePopupListener.this.notifyAdd(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        });
        this.scheduledExecutorService = applicationContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
    }

    public DataModelListener.NotificationResult notifyAdd(Message message) {
        if (this.shouldShowPopup(message.getSpecialMessage())) {
            if (this.isRecallTradeMessage(message)) {
                this.eventBus.post(new TradeRecallRequestedMessageEvent(message));
            }
            if (this.isTradeCancelPopupGrouping(message.getSpecialMessage())) {
                this.handleTradeCancelPopupGrouping(message);
            } else {
                this.showMessage(Util.getLabel("commons_info"), message.getMessageText(), UserAlertService.Flag.INFO);
            }
        }
        if (this.applicationConfigurationService.getBooleanApplicationProperty("showRecallErrorPopup") && GROUP_RECALL_POPUP_TRIGGERS.contains((Object)message.getSpecialMessage())) {
            this.addAndStartTimer(message);
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private void handleTradeCancelPopupGrouping(Message message) {
        Long lastTradeCancelPopupTS = this.backendConnectionGateway.getSession().getLastTradeCancelPopupTS();
        long tradeCancelPopupGroupLimit = TimeUnit.MINUTES.toMillis(this.tradingSettingsService.getTradeCancelPopupGroupLimit().intValue());
        if (lastTradeCancelPopupTS == null || lastTradeCancelPopupTS < System.currentTimeMillis() - tradeCancelPopupGroupLimit) {
            this.showMessage(Util.getLabel("commons_info"), message.getMessageText(), UserAlertService.Flag.INFO);
            this.backendConnectionGateway.getSession().setTradeCancelPopupGrouping(false);
        } else if (lastTradeCancelPopupTS >= System.currentTimeMillis() - tradeCancelPopupGroupLimit && !this.backendConnectionGateway.getSession().isTradeCancelPopupGrouping()) {
            this.showMessage(Util.getLabel("commons_info"), Util.getLabel("trade_cancelled_private_trader_grouping"), UserAlertService.Flag.INFO);
            this.backendConnectionGateway.getSession().setTradeCancelPopupGrouping(true);
        }
        this.backendConnectionGateway.getSession().setLastTradeCancelPopupTS(System.currentTimeMillis());
    }

    private boolean isTradeCancelPopupGrouping(SpecialMessage specialMessage) {
        return specialMessage == SpecialMessage.TRADE_CANCELLED && !this.userService.getOwnUserRoles().isAdmin() && this.tradingSettingsService.getTradeCancelPopupGroupLimit() != null;
    }

    private void addAndStartTimer(Message message) {
        this.recallMessageQueue.add(message.getSpecialMessage());
        if (this.recallMessagesScheduled.compareAndSet(false, true)) {
            this.scheduledExecutorService.schedule(this.showRecallWarning(), 1L, TimeUnit.SECONDS);
        }
    }

    private Runnable showRecallWarning() {
        return () -> {
            this.recallMessagesScheduled.set(false);
            TreeSet recallMessages = new TreeSet();
            this.recallMessageQueue.drainTo(recallMessages);
            boolean tooClose = recallMessages.contains((Object)SpecialMessage.TRADE_RECALL_REJECTED_DELIVERY_TOO_CLOSE);
            boolean tooLong = recallMessages.contains((Object)SpecialMessage.TRADE_RECALL_REJECTED_EXECUTION_TOO_LONG);
            if (tooClose && !tooLong) {
                this.showMessage(Util.getLabel("tradeRecallWarn_title"), Util.getLabel("tradeRecallWarn_tooClose"), UserAlertService.Flag.WARNING);
            } else if (tooLong && !tooClose) {
                this.showMessage(Util.getLabel("tradeRecallWarn_title"), Util.getLabel("tradeRecallWarn_tooLong"), UserAlertService.Flag.WARNING);
            } else if (tooLong && tooClose) {
                this.showMessage(Util.getLabel("tradeRecallWarn_title"), Util.getLabel("tradeRecallWarn_tooCloseOrLong"), UserAlertService.Flag.WARNING);
            }
        };
    }

    private void showMessage(String title, String messageText, UserAlertService.Flag flag) {
        FxUtil.runInFxThread(() -> this.userAlertService.showConfirmationDialog(title, messageText, flag));
    }

    private boolean isRecallTradeMessage(Message message) {
        return SpecialMessage.TRADE_RECALL_REQUESTED_ON_BEHALF.equals((Object)message.getSpecialMessage()) || SpecialMessage.TRADE_RECALL_REQUESTED.equals((Object)message.getSpecialMessage());
    }

    private boolean shouldShowPopup(SpecialMessage specialMessage) {
        return specialMessage == SpecialMessage.FIRST_LOGIN_AFTER_CONNECTION_LOSS || this.showingPopups && this.popupTriggers().contains((Object)specialMessage);
    }

    private EnumSet<SpecialMessage> popupTriggers() {
        return this.userService.getOwnUserRoles().isAdmin() ? POPUP_TRIGGERS_ADMIN : POPUP_TRIGGERS_TRADER;
    }

    @Subscribe
    public void handleLoadingStartedEvent(LoadingStartedEvent loadingStarted) {
        this.showingPopups = false;
    }

    @Subscribe
    public void handleLoadingFinishedEvent(LoadingFinishedEvent loadingFinished) {
        this.showingPopups = true;
    }
}

