/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry;

import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.type.BasketRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import java.util.Map;
import java.util.Set;

public class SentOrders {
    private final ResponseHandler responseHandler;
    private final Exchange exchange;
    private final BasketRestriction basketRestriction;
    private final Map<String, OrderType> clientOrderIds;
    private final String correlationId;

    public SentOrders(ResponseHandler responseHandler, Exchange exchange, BasketRestriction basketRestriction, Map<String, OrderType> clientOrderIds, String correlationId) {
        this.responseHandler = responseHandler;
        this.exchange = exchange;
        this.basketRestriction = basketRestriction;
        this.clientOrderIds = clientOrderIds;
        this.correlationId = correlationId;
    }

    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public BasketRestriction getBasketRestriction() {
        return this.basketRestriction;
    }

    public Set<String> getClientOrderIds() {
        return this.clientOrderIds.keySet();
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public OrderType getSentOrderType(String clientOrderId) {
        return this.clientOrderIds.get(clientOrderId);
    }
}

