/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.basket;

import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.BasketEntry;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import javafx.beans.binding.BooleanBinding;
import javafx.collections.ObservableList;

public class AllOrdersLinkedEnabledBinding
extends BooleanBinding {
    private final ObservableList<BasketEntry> basketEntries;
    private final DataModel<String, Product> productDataModel;

    public AllOrdersLinkedEnabledBinding(ObservableList<BasketEntry> basketEntries, DataModel<String, Product> productDataModel) {
        this.productDataModel = productDataModel;
        this.basketEntries = basketEntries;
        this.bind(basketEntries);
    }

    @Override
    protected boolean computeValue() {
        return this.basketEntries.stream().allMatch(this::isLinkedOrdersEnabled);
    }

    private boolean isLinkedOrdersEnabled(BasketEntry basketEntry) {
        Product byId = this.productDataModel.findById(basketEntry.getProductName());
        return byId != null && byId.isLinkedOrderProduct();
    }
}

