/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.orderquote;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.comxerv.OrderQuoteNotification;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderQuoteNotificationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderQuoteUI;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class OrderQuoteNotificationServiceImpl
implements OrderQuoteNotificationService {
    protected static final SettingsService.Settings<Boolean> ENABLE_ORDER_REQUEST_POPUP_SETTINGS = new SettingsService.Settings<Boolean>("enableOrderRequestPopup", false);
    private final ApplicationContext applicationContext;
    private final SettingsService settingsService;

    @Inject
    public OrderQuoteNotificationServiceImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.settingsService = applicationContext.getService(SettingsService.class);
    }

    @Override
    public void handleOrderQuoteNotification(OrderQuoteNotification orderQuoteNotification) {
        if (this.isOrderQuotePopupEnabled()) {
            this.applicationContext.getService(OrderQuoteUI.class).showOrderQuoteNotification(orderQuoteNotification);
        }
    }

    @Override
    public boolean isOrderQuotePopupEnabled() {
        return this.settingsService.loadSettings(ENABLE_ORDER_REQUEST_POPUP_SETTINGS);
    }

    @Override
    public void setOrderQuotePopupEnabled(boolean enabled) {
        this.settingsService.storeSettings(ENABLE_ORDER_REQUEST_POPUP_SETTINGS, enabled);
    }
}

