/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.profile;

import com.deutscheboerse.comxerv.comtrader.service.profile.StageState;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class UserProfile {
    private Long lastProfileSaveTimeStamp;
    private String userName;
    private String exchangeId;
    private String environment;
    private long formatVersion;
    private final Map<String, Object> settings;
    private final Map<String, StageState> stages;
    private final Map<String, Object> componentData;

    public UserProfile() {
        this.settings = new ConcurrentHashMap<String, Object>();
        this.stages = new ConcurrentHashMap<String, StageState>();
        this.componentData = new ConcurrentHashMap<String, Object>();
    }

    protected UserProfile(UserProfile other) {
        this.settings = new ConcurrentHashMap<String, Object>(other.settings);
        this.componentData = new ConcurrentHashMap<String, Object>(other.componentData);
        this.stages = new ConcurrentHashMap<String, StageState>();
        other.getStages().forEach((key, value) -> this.stages.put((String)key, new StageState((StageState)value)));
    }

    public void setSetting(String key, Object value) {
        this.settings.put(key, value);
    }

    public Object getSetting(String key) {
        return this.settings.get(key);
    }

    public Map<String, Object> getSettings() {
        return new HashMap<String, Object>(this.settings);
    }

    public void setSettings(Map<String, Object> settings) {
        this.settings.clear();
        this.settings.putAll(settings);
    }

    public StageState getStageState(String suffix) {
        return this.stages.get(suffix);
    }

    public void setStageState(String suffix, StageState stageState) {
        this.stages.put(suffix, stageState);
    }

    public void clearStages() {
        this.stages.clear();
    }

    public Map<String, StageState> getStages() {
        return new HashMap<String, StageState>(this.stages);
    }

    public void setStages(Map<String, StageState> stages) {
        this.stages.clear();
        this.stages.putAll(stages);
    }

    public Object getComponentData(String key) {
        return this.componentData.get(key);
    }

    public void setComponentData(String key, Object data) {
        this.componentData.put(key, data);
    }

    public Map<String, Object> getComponentData() {
        return new HashMap<String, Object>(this.componentData);
    }

    public void setComponentData(Map<String, Object> componentData) {
        this.componentData.clear();
        this.componentData.putAll(componentData);
    }

    public Long getLastProfileSaveTimeStamp() {
        return this.lastProfileSaveTimeStamp;
    }

    public void setLastProfileSaveTimeStamp(Long lastProfileSaveTimeStamp) {
        this.lastProfileSaveTimeStamp = lastProfileSaveTimeStamp;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public void setExchangeId(String exchangeId) {
        this.exchangeId = exchangeId;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public long getFormatVersion() {
        return this.formatVersion;
    }

    public void setFormatVersion(long formatVersion) {
        this.formatVersion = formatVersion;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("userName", this.userName).append("exchangeId", this.exchangeId).append("environment", this.environment).append("formatVersion", this.formatVersion).append("lastProfileSaveTimeStamp", this.lastProfileSaveTimeStamp).toString();
    }
}

