/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.profile;

import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.OrderEntryRule;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileContentWithFormatVersion;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigration;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigrationService;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileSerializer;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1000002OrderEntryProtectionRuleList
implements ProfileMigration {
    private static final Logger LOG = LoggerFactory.getLogger(V1000002OrderEntryProtectionRuleList.class);
    private static final long NEW_VERSION = 1000002L;
    private final ProfileSerializer profileSerializer;

    @Inject
    public V1000002OrderEntryProtectionRuleList(ProfileMigrationService profileMigrationService, ProfileSerializer profileSerializer) {
        profileMigrationService.registerProfileMigration(this, 1000002L);
        this.profileSerializer = profileSerializer;
    }

    @Override
    public ProfileContentWithFormatVersion apply(ProfileContentWithFormatVersion profile) {
        LOG.info("Running profile migration");
        profile.setFormatVersion(1000002L);
        for (Map.Entry<String, String> entry : profile.getSettings().entrySet()) {
            if (!"orderEntryProtectionRuleList".equals(entry.getKey()) || entry.getValue() == null || !entry.getValue().contains("SerializableOrderEntryRule")) continue;
            entry.setValue(this.serializeValue(this.deserializeValue(entry.getValue())));
        }
        return profile;
    }

    private String serializeValue(List<OrderEntryRule> value) {
        return this.profileSerializer.writeValue(value);
    }

    private List<OrderEntryRule> deserializeValue(String serializedValue) {
        return ((List)this.profileSerializer.readValue(serializedValue)).stream().map(OrderEntryRule::new).toList();
    }
}

