/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.profile;

import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileContentWithFormatVersion;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigration;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigrationService;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1000004DelIndicativeOrders
implements ProfileMigration {
    private static final Logger LOG = LoggerFactory.getLogger(V1000004DelIndicativeOrders.class);
    private static final long NEW_VERSION = 1000004L;

    @Inject
    public V1000004DelIndicativeOrders(ProfileMigrationService profileMigrationService) {
        profileMigrationService.registerProfileMigration(this, 1000004L);
    }

    @Override
    public ProfileContentWithFormatVersion apply(ProfileContentWithFormatVersion profile) {
        LOG.info("Running profile migration");
        profile.setFormatVersion(1000004L);
        profile.getSettings().remove("showImpliedOrders");
        for (Map.Entry<String, String> entry : profile.getComponentData().entrySet()) {
            String value = entry.getValue();
            if (!StringUtils.isNotEmpty(value)) continue;
            value = value.replaceAll("\\<com\\.deutscheboerse\\.comxerv\\.comtrader\\.jfx\\.components\\.state\\.BottomToolbarItemState\\>.*?indicativeOrdersFilterBottomToolbarChoiceBox.*?\\</com\\.deutscheboerse\\.comxerv\\.comtrader\\.jfx\\.components\\.state\\.BottomToolbarItemState\\>", "");
            entry.setValue(value);
        }
        return profile;
    }
}

