/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.settings;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.service.event.SaveConfigurationEvent;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileManager;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsLoadedEvent;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SettingsServiceImpl
implements SettingsService {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsServiceImpl.class);
    private final ProfileManager profileManager;
    private final Map<String, Object> settings;
    private final EventBus eventBus;

    @Inject
    public SettingsServiceImpl(ApplicationContext appContext) {
        this.profileManager = appContext.getService(ProfileManager.class);
        this.settings = new ConcurrentHashMap<String, Object>();
        this.eventBus = appContext.getService(EventBus.class);
        this.eventBus.register(this);
    }

    @Override
    public <T> T loadSettings(SettingsService.Settings<T> setting) {
        Object value = this.settings.getOrDefault(setting.getKey(), setting.getDefaultValue());
        if (setting.getClassValue() != null && !setting.getClassValue().isAssignableFrom(value.getClass())) {
            LOG.warn("Setting {} corrupted: {}", (Object)setting.getKey(), value);
            return setting.getDefaultValue();
        }
        return (T)value;
    }

    @Override
    public <T> void storeSettings(SettingsService.Settings<T> setting, T value) {
        this.settings.put(setting.getKey(), value);
    }

    @Override
    public void loadAllSettings() {
        this.settings.clear();
        this.settings.putAll(this.profileManager.getCurrentProfile().getSettings());
        this.eventBus.post(new SettingsLoadedEvent());
    }

    @Subscribe
    public void handleSaveConfiguration(SaveConfigurationEvent saveConfigurationEvent) {
        this.profileManager.getCurrentProfile().setSettings(this.settings);
    }
}

