/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util;

import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Bootstrap {
    public static final String APPLICATION_PROPERTIES_PATH = "/guisettings/application.properties";
    public static final String CONNECTION_PARAMETERS_PATH = "/connection-parameters.properties";

    private Bootstrap() {
    }

    public static Properties getApplicationProperties() {
        return Bootstrap.load(APPLICATION_PROPERTIES_PATH);
    }

    private static Properties load(String path) {
        Properties properties;
        block8: {
            Properties properties2 = new Properties();
            InputStream resourceAsStream = Bootstrap.class.getResourceAsStream(path);
            try {
                properties2.load(resourceAsStream);
                properties = properties2;
                if (resourceAsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ParseException(path, properties2, e);
                }
            }
            resourceAsStream.close();
        }
        return properties;
    }

    public static ConnectionParametersWithFallback getConnectionParameters() {
        ConnectionParametersWithFallback connectionParametersWithFallback;
        block8: {
            Properties properties = new Properties();
            InputStream resourceAsStream = Bootstrap.class.getResourceAsStream(CONNECTION_PARAMETERS_PATH);
            try {
                properties.load(resourceAsStream);
                connectionParametersWithFallback = ConnectionParametersWithFallback.fromProperties(properties);
                if (resourceAsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    throw new ParseException(CONNECTION_PARAMETERS_PATH, properties, e);
                }
            }
            resourceAsStream.close();
        }
        return connectionParametersWithFallback;
    }

    public static class ParseException
    extends RuntimeException {
        private static final long serialVersionUID = 4247299735947587712L;

        public ParseException(String resource, Properties properties, Exception cause) {
            super("Error when parsing connection parameters. Resource=" + resource + " Properties=" + String.valueOf(properties), cause);
        }
    }
}

