/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
    }

    public static boolean loadCustomLogConfig(File file) {
        boolean bl;
        block8: {
            FileInputStream openInputStream = FileUtils.openInputStream(file);
            try {
                LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
                context.reset();
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext(context);
                configurator.doConfigure(openInputStream);
                bl = true;
                if (openInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (openInputStream != null) {
                        try {
                            ((InputStream)openInputStream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JoranException | IOException e) {
                    LOG.error("Error loading custom log config file", e);
                    return false;
                }
            }
            ((InputStream)openInputStream).close();
        }
        return bl;
    }

    public static void openLogFileFolder() {
        File file = FileUtil.findLogFolder();
        if (file != null) {
            FileUtil.openDirectory(file);
        } else {
            LOG.error("Can't find any file appenders.");
        }
    }

    public static File findLogFolder() {
        File file = null;
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (ch.qos.logback.classic.Logger logger : context.getLoggerList()) {
            Iterator<Appender<ILoggingEvent>> index = logger.iteratorForAppenders();
            while (index.hasNext()) {
                file = FileUtil.findLogFolder(index.next());
            }
        }
        return file;
    }

    private static File findLogFolder(Appender<ILoggingEvent> appender) {
        if (appender instanceof FileAppender) {
            return new File(((FileAppender)appender).getFile()).getParentFile();
        }
        if (appender instanceof AsyncAppender) {
            Iterator index = ((AsyncAppender)appender).iteratorForAppenders();
            while (index.hasNext()) {
                File file = FileUtil.findLogFolder(index.next());
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    private static void openDirectory(File file) {
        try {
            FileUtil.openFile(file);
        }
        catch (IOException e) {
            LOG.error("Can't open logfile folder", e);
        }
    }

    public static void openFutureFileSilent(File file) {
        if (file != null) {
            try {
                FileUtil.openFile(file);
            }
            catch (Exception e) {
                LOG.error("Cannot open file.", e);
            }
        }
    }

    public static void openFile(File file) throws IOException {
        if (System.getProperty("os.name").toLowerCase().contains("linux") || System.getProperty("os.name").toLowerCase().contains("unix")) {
            String path = file.getPath();
            if (FileUtil.runSystemCommand("xdg-open", path) || FileUtil.runSystemCommand("kde-open", path) || FileUtil.runSystemCommand("gnome-open", path)) {
                return;
            }
        } else {
            Desktop.getDesktop().open(file);
        }
    }

    private static boolean runSystemCommand(String ... args2) {
        try {
            Process p = Runtime.getRuntime().exec(args2);
            try {
                p.exitValue();
                return false;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
    }
}

