/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServiceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteServiceUtil.class);
    private final String primaryProfileStorageUrl;
    private final String secondaryProfileStorageUrl;
    private final boolean disableHostnameCheck;

    public RemoteServiceUtil() {
        this("/remote.properties");
    }

    protected RemoteServiceUtil(String resourcePath) {
        if (Boolean.getBoolean("disableRemoteProfileServices")) {
            this.primaryProfileStorageUrl = null;
            this.secondaryProfileStorageUrl = null;
            this.disableHostnameCheck = false;
            return;
        }
        Properties properties = new Properties();
        try (InputStream remoteProperties = RemoteServiceUtil.class.getResourceAsStream(resourcePath);){
            if (remoteProperties != null) {
                properties.load(remoteProperties);
            } else {
                LOG.info("Could not find remote.properties. Remote profile storage and remote performance log will not be used.");
            }
        }
        catch (IOException e) {
            LOG.error("Could not load remote.properties", e);
        }
        this.primaryProfileStorageUrl = properties.getProperty("profile-storage-primary");
        this.secondaryProfileStorageUrl = properties.getProperty("profile-storage-secondary");
        this.disableHostnameCheck = Boolean.parseBoolean(properties.getProperty("remote.certificateHostnameCheck.disable"));
    }

    public boolean useRemoteServices() {
        return this.primaryProfileStorageUrl != null;
    }

    public String getPrimaryProfileStorageUrl() {
        return this.primaryProfileStorageUrl;
    }

    public String getSecondaryProfileStorageUrl() {
        return this.secondaryProfileStorageUrl;
    }

    public boolean getDisableHostnameCheck() {
        return this.disableHostnameCheck;
    }
}

