/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.control.table;

import com.deutscheboerse.ui.jfx.util.binding.ConstantObservableValue;
import com.deutscheboerse.ui.jfx.util.binding.SelectByGetters;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class PropertyPathValueFactory<S, T>
implements Callback<TableColumn.CellDataFeatures<S, T>, ObservableValue<T>> {
    private String pojoPropertyPath;
    private String fxPropertyPath;
    private String[] fxPropertyPathItems;
    private PropertyValueFactory<Object, T> propertyValueFactoryDelegate;
    private SelectByGetters<Object, T> selectByGetters;

    public PropertyPathValueFactory() {
    }

    public PropertyPathValueFactory(String pojoPropertyPath) {
        this.setPojoPropertyPath(pojoPropertyPath);
    }

    @Override
    public ObservableValue<T> call(TableColumn.CellDataFeatures<S, T> stCellDataFeatures) {
        Object value = stCellDataFeatures.getValue();
        if (this.pojoPropertyPath != null && !this.pojoPropertyPath.isEmpty()) {
            if (this.selectByGetters == null) {
                this.selectByGetters = new SelectByGetters(this.pojoPropertyPath);
            }
            value = this.selectByGetters.evaluate(value);
        }
        ConstantObservableValue<S> fxRoot = new ConstantObservableValue<S>(value);
        if (this.fxPropertyPathItems == null) {
            return fxRoot;
        }
        if (value == null) {
            return ConstantObservableValue.nullValue();
        }
        if (this.fxPropertyPathItems.length == 1) {
            if (this.propertyValueFactoryDelegate == null) {
                this.propertyValueFactoryDelegate = new PropertyValueFactory(this.fxPropertyPathItems[0]);
            }
            return this.propertyValueFactoryDelegate.call(new TableColumn.CellDataFeatures(null, null, fxRoot.getValue()));
        }
        ObjectBinding targetProperty = Bindings.select(fxRoot, this.fxPropertyPathItems);
        return new WeakObservableValue(targetProperty);
    }

    public String getFxPropertyPath() {
        return this.fxPropertyPath;
    }

    public void setFxPropertyPath(String fxPropertyPath) {
        if (this.fxPropertyPath != null) {
            throw new IllegalStateException(" FX Property path can be set only once");
        }
        this.fxPropertyPath = fxPropertyPath;
        this.fxPropertyPathItems = fxPropertyPath.split("\\.");
    }

    public String getPojoPropertyPath() {
        return this.pojoPropertyPath;
    }

    public void setPojoPropertyPath(String pojoPropertyPath) {
        if (this.pojoPropertyPath != null) {
            throw new IllegalStateException("Pojo Property path can be set only once");
        }
        this.pojoPropertyPath = pojoPropertyPath;
        this.selectByGetters = null;
    }
}

