/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.factory.primitive.BooleanBags;
import org.eclipse.collections.api.factory.primitive.BooleanLists;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.tuple.primitive.BooleanBooleanPair;
import org.eclipse.collections.impl.factory.primitive.BooleanSets;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanEmptySet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanSetSerializationProxy;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableTrueFalseSet;

final class ImmutableTrueSet
implements ImmutableBooleanSet,
Serializable {
    static final ImmutableBooleanSet INSTANCE = new ImmutableTrueSet();

    private ImmutableTrueSet() {
    }

    @Override
    public ImmutableBooleanSet newWith(boolean element) {
        return element ? this : ImmutableTrueFalseSet.INSTANCE;
    }

    @Override
    public ImmutableBooleanSet newWithout(boolean element) {
        return element ? ImmutableBooleanEmptySet.INSTANCE : this;
    }

    @Override
    public ImmutableBooleanSet newWithAll(BooleanIterable elements) {
        ImmutableBooleanSet result = this;
        BooleanIterator booleanIterator = elements.booleanIterator();
        while (booleanIterator.hasNext()) {
            result = result.newWith(booleanIterator.next());
        }
        return result;
    }

    @Override
    public ImmutableBooleanSet newWithoutAll(BooleanIterable elements) {
        return elements.contains(true) ? ImmutableBooleanEmptySet.INSTANCE : this;
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new TrueIterator();
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        procedure.value(true);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, true);
    }

    @Override
    public RichIterable<BooleanIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with(this);
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return predicate.accept(true) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(true);
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(true);
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(true);
    }

    @Override
    public ImmutableBooleanSet select(BooleanPredicate predicate) {
        return predicate.accept(true) ? this : ImmutableBooleanEmptySet.INSTANCE;
    }

    @Override
    public ImmutableBooleanSet reject(BooleanPredicate predicate) {
        return predicate.accept(true) ? ImmutableBooleanEmptySet.INSTANCE : this;
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return predicate.accept(true) || ifNone;
    }

    @Override
    public <V> ImmutableSet<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Sets.immutable.with(function.valueOf(true));
    }

    @Override
    public boolean[] toArray() {
        return new boolean[]{true};
    }

    @Override
    public boolean[] toArray(boolean[] target) {
        if (target.length < 1) {
            target = new boolean[]{true};
        } else {
            target[0] = true;
        }
        return target;
    }

    @Override
    public boolean contains(boolean value) {
        return value;
    }

    @Override
    public boolean containsAll(boolean ... source) {
        for (boolean item : source) {
            if (item) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator2 = source.booleanIterator();
        while (iterator2.hasNext()) {
            if (iterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public BooleanSet freeze() {
        return this;
    }

    @Override
    public ImmutableBooleanSet toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public LazyIterable<BooleanBooleanPair> cartesianProduct(BooleanSet set) {
        return BooleanSets.cartesianProduct(this, set);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanSet)) {
            return false;
        }
        BooleanSet other = (BooleanSet)obj;
        return !other.contains(false) && other.contains(true);
    }

    @Override
    public int hashCode() {
        return 1231;
    }

    @Override
    public String toString() {
        return "[true]";
    }

    @Override
    public String makeString() {
        return "true";
    }

    @Override
    public String makeString(String separator) {
        return "true";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + "true" + end;
    }

    @Override
    public void appendString(Appendable appendable) {
        try {
            appendable.append("true");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        try {
            appendable.append("true");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append("true");
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanLists.mutable.withAll(this);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanSets.mutable.withAll(this);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanBags.mutable.withAll(this);
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    private Object writeReplace() {
        return new ImmutableBooleanSetSerializationProxy(this);
    }

    private static final class TrueIterator
    implements BooleanIterator {
        private int currentIndex;

        private TrueIterator() {
        }

        @Override
        public boolean next() {
            if (this.currentIndex == 0) {
                ++this.currentIndex;
                return true;
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex == 0;
        }
    }
}

