/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.factory.stack.primitive.ImmutableCharStackFactory;
import org.eclipse.collections.api.stack.primitive.ImmutableCharStack;
import org.eclipse.collections.impl.factory.primitive.CharStacks;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableCharArrayStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableCharEmptyStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableCharSingletonStack;

@ServiceProvider(value=ImmutableCharStackFactory.class)
public class ImmutableCharStackFactoryImpl
implements ImmutableCharStackFactory {
    public static final ImmutableCharStackFactory INSTANCE = new ImmutableCharStackFactoryImpl();

    @Override
    public ImmutableCharStack empty() {
        return ImmutableCharEmptyStack.INSTANCE;
    }

    @Override
    public ImmutableCharStack of() {
        return this.empty();
    }

    @Override
    public ImmutableCharStack with() {
        return this.empty();
    }

    @Override
    public ImmutableCharStack of(char one) {
        return this.with(one);
    }

    @Override
    public ImmutableCharStack with(char one) {
        return new ImmutableCharSingletonStack(one);
    }

    @Override
    public ImmutableCharStack of(char ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableCharStack with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableCharArrayStack.newStackWith(items);
    }

    @Override
    public ImmutableCharStack ofAll(CharIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableCharStack withAll(CharIterable items) {
        if (items instanceof ImmutableCharStack) {
            return (ImmutableCharStack)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableCharStack ofAll(Iterable<Character> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableCharStack withAll(Iterable<Character> iterable) {
        return CharStacks.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableCharStack ofAllReversed(CharIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public ImmutableCharStack withAllReversed(CharIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableCharArrayStack.newStackFromTopToBottom(items);
    }
}

