/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.TextFlowSpan;
import org.fxmisc.richtext.model.TwoLevelNavigator;

class TextFlowLayout {
    private TextFlow flow;
    private List<TextFlowSpan> lineMetrics = new ArrayList<TextFlowSpan>();
    private int lineCount = -1;
    private static final TextFlowSpan EMPTY_SPAN = new TextFlowSpan(0, 0, 0.0, 0.0, 0.0);

    TextFlowLayout(TextFlow tf) {
        tf.getChildren().addListener(ob -> {
            this.lineCount = -1;
        });
        tf.widthProperty().addListener(ob -> {
            this.lineCount = -1;
        });
        this.flow = tf;
    }

    float getLineCenter(int lineNo) {
        return lineNo >= 0 && this.getLineCount() > 0 ? this.lineMetrics.get(lineNo).getCenterY() : 1.0f;
    }

    int getLineLength(int lineNo) {
        return this.getLineSpan(lineNo).getLength();
    }

    TextFlowSpan getLineSpan(int lineNo) {
        return lineNo >= 0 && this.getLineCount() > 0 ? this.lineMetrics.get(lineNo) : EMPTY_SPAN;
    }

    TextFlowSpan getLineSpan(float y) {
        int lastLine = this.getLineCount();
        if (lastLine < 1) {
            return EMPTY_SPAN;
        }
        return this.lineMetrics.stream().filter(tfs -> (double)y < tfs.getBounds().getMaxY()).findFirst().orElse(this.lineMetrics.get(Math.max(0, lastLine - 1)));
    }

    TwoLevelNavigator getTwoLevelNavigator() {
        return new TwoLevelNavigator(this::getLineCount, this::getLineLength);
    }

    int getLineCount() {
        if (this.lineCount > -1) {
            return this.lineCount;
        }
        this.lineCount = 0;
        this.lineMetrics.clear();
        double totLines = 0.0;
        double prevMaxY = -1.0;
        int totCharSoFar = 0;
        for (Node n : this.flow.getChildrenUnmodifiable()) {
            if (!n.isManaged()) continue;
            Bounds nodeBounds = n.getBoundsInParent();
            int length = n instanceof Text ? ((Text)n).getText().length() : 1;
            PathElement[] shape = this.flow.rangeShape(totCharSoFar, totCharSoFar + length);
            double lines = Math.max(1.0, Math.floor(shape.length / 5));
            double nodeMinY = Math.max(0.0, nodeBounds.getMinY());
            if (lines > 1.0) {
                if (totLines > 0.0) {
                    lines -= 1.0;
                }
                totLines += lines;
            } else if (nodeMinY >= prevMaxY) {
                totLines += 1.0;
            }
            if ((double)this.lineMetrics.size() < totLines) {
                if (shape.length == 0) {
                    this.lineMetrics.add(new TextFlowSpan(totCharSoFar, length, nodeMinY, nodeBounds.getWidth(), nodeBounds.getHeight()));
                    totCharSoFar += length;
                } else {
                    for (int ele = 1; ele < shape.length; ele += 5) {
                        LineTo eleLine = (LineTo)shape[ele];
                        double segWidth = eleLine.getX();
                        double lineMinY = eleLine.getY();
                        double charHeight = ((LineTo)shape[ele + 1]).getY() - lineMinY;
                        Point2D endPoint = new Point2D(segWidth - 1.0, lineMinY + charHeight / 2.0);
                        int segLen = this.flow.hitTest(endPoint).getCharIndex();
                        segLen -= totCharSoFar - 1;
                        if (ele == 1 && nodeMinY < prevMaxY) {
                            this.adjustLineMetrics(segLen, segWidth - ((MoveTo)shape[ele - 1]).getX(), charHeight);
                        } else {
                            this.lineMetrics.add(new TextFlowSpan(totCharSoFar, segLen, lineMinY, segWidth, charHeight));
                        }
                        totCharSoFar += segLen;
                    }
                }
            } else {
                this.adjustLineMetrics(length, nodeBounds.getWidth(), nodeBounds.getHeight());
                totCharSoFar += length;
            }
            prevMaxY = Math.max(prevMaxY, nodeBounds.getMaxY());
        }
        this.lineCount = (int)totLines;
        if (this.lineCount > 0) {
            return this.lineCount;
        }
        this.lineCount = -1;
        return 0;
    }

    private void adjustLineMetrics(int length, double width, double height) {
        TextFlowSpan span = this.lineMetrics.get(this.lineMetrics.size() - 1);
        span.addLengthAndWidth(length, width);
        if (height > span.getHeight()) {
            span.setHeight(height);
        }
    }
}

