/*
 * Decompiled with CFR 0.152.
 */
package tech.energyit.statsd.async;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import tech.energyit.statsd.IOUtils;
import tech.energyit.statsd.Sender;
import tech.energyit.statsd.StatsDClientErrorHandler;
import tech.energyit.statsd.SynchronousSender;
import tech.energyit.statsd.async.SenderEvent;
import tech.energyit.statsd.async.SenderEventFactory;
import tech.energyit.statsd.async.SenderEventHandler;

public class AsynchronousSender
implements Sender,
Closeable {
    private static final int RINGBUFFER_SIZE = 256;
    private final Disruptor<SenderEvent> disruptor;
    private final SynchronousSender sender;
    private final StatsDClientErrorHandler errorHandler;
    private final BiConsumer<AsynchronousSender, ByteBuffer> ringBufferFullHandler;

    private AsynchronousSender(Supplier<DatagramChannel> socketSupplier, Supplier<InetSocketAddress> addressLookup, StatsDClientErrorHandler errorHandler, int ringbufferSize, BiConsumer<AsynchronousSender, ByteBuffer> ringBufferFullHandler) {
        this.disruptor = new Disruptor((EventFactory)new SenderEventFactory(), ringbufferSize, (ThreadFactory)DaemonThreadFactory.INSTANCE, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.sender = SynchronousSender.builder().withSocketSupplier(socketSupplier).withAddressLookup(addressLookup).withErrorHandler(errorHandler).build();
        this.disruptor.handleEventsWith(new EventHandler[]{new SenderEventHandler(this.sender)});
        this.disruptor.start();
        this.ringBufferFullHandler = ringBufferFullHandler;
        this.errorHandler = errorHandler;
    }

    @Override
    public void send(ByteBuffer msg) {
        if (!this.disruptor.getRingBuffer().tryPublishEvent((senderEvent, seq, message) -> senderEvent.set((ByteBuffer)message), (Object)msg)) {
            this.ringBufferFullHandler.accept(this, msg);
        }
    }

    @Override
    public void close() {
        this.disruptor.shutdown();
        this.sender.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final BiConsumer<AsynchronousSender, ByteBuffer> SKIPPING_HANDLER = (s, m) -> ((AsynchronousSender)s).errorHandler.handle("Ringbuffer full. Skipping...", new Object[0]);
        private Supplier<DatagramChannel> socketSupplier = IOUtils::newDatagramChannel;
        private Supplier<InetSocketAddress> addressLookup = () -> new InetSocketAddress(IOUtils.inetAddress("localhost"), 8125);
        private StatsDClientErrorHandler errorHandler = StatsDClientErrorHandler.NO_OP_HANDLER;
        private int ringbufferSize = 256;
        private BiConsumer<AsynchronousSender, ByteBuffer> ringBufferFullHandler = SKIPPING_HANDLER;

        public Builder withHostAndPort(String hostname, int port) {
            this.addressLookup = () -> new InetSocketAddress(IOUtils.inetAddress(hostname), port);
            return this;
        }

        public Builder withSocketSupplier(Supplier<DatagramChannel> socketSupplier) {
            this.socketSupplier = socketSupplier;
            return this;
        }

        public Builder withAddressLookup(Supplier<InetSocketAddress> addressLookup) {
            this.addressLookup = addressLookup;
            return this;
        }

        public Builder withErrorHandler(StatsDClientErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder withRingbufferSize(int ringbufferSize) {
            this.ringbufferSize = ringbufferSize;
            return this;
        }

        public Builder skipMessageWhenRingbufferIsFull() {
            this.ringBufferFullHandler = SKIPPING_HANDLER;
            return this;
        }

        public Builder publishSynchronouslyWhenRingbufferIsFull() {
            this.ringBufferFullHandler = (s, m) -> ((AsynchronousSender)s).sender.send((ByteBuffer)m);
            return this;
        }

        public AsynchronousSender build() {
            return new AsynchronousSender(this.socketSupplier, this.addressLookup, this.errorHandler, this.ringbufferSize, this.ringBufferFullHandler);
        }
    }
}

