/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.ComXervMarshaller;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHubState;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.entities.type.HubToHubStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.monitoring.Monitor;
import com.deutscheboerse.comxerv.comtrader.service.LoginException;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AbstractAmqpBackend;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpRpcClient;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpUtil;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ErrorHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.MarshallerException;
import com.deutscheboerse.comxerv.comtrader.service.amqp.MessageSequenceCheck;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ResponseWithCorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.amqp.SimpleResponseWithCorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.info.InfoLogger;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AbstractComXervAmqpBackend
extends AbstractAmqpBackend {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComXervAmqpBackend.class);
    private static final Logger PERFORMANCE_LOG = LoggerFactory.getLogger("performance");
    private static final Marker DELAY_MARKER = MarkerFactory.getMarker("DELAY");
    public static final String TIMESTAMP = "server-timestamp";
    private static final NullResponse NULL_RESPONSE = new NullResponse();
    private static final String GZIP_COMPRESSION_ENCODING = "gzip";
    private static final String ERR_SEND_REQUEST_MSQ = "error sending request";
    private static final int MISSED_HEARTBEAT_COUNT = 6;
    private static final int MISSED_H2H_HEARTBEAT_COUNT = 3;
    private static final long H2H_HEARTBEAT_INTERVAL = 5000L;
    private static final int MISSED_FIRST_HEARTBEAT_INTERVAL = 5000;
    private static final int MESSAGE_DELAY_THRESHOLD = 2000;
    private final ApplicationContext applicationContext;
    private volatile long heartbeatInterval = -1L;
    private volatile DateTime lastHeartbeatDate;
    private volatile DateTime lastHubToHubHeartbeatDate;
    private final AtomicInteger lostHeartBeats;
    private final AtomicInteger firstHeartBeat;
    private final AtomicInteger lostHubToHubHeartBeats;
    private ScheduledFuture<?> heartbeatTask;
    private ScheduledFuture<?> firstHeartbeatTask;
    private ScheduledFuture<?> hubToHubHeartbeatTask;
    private Monitor monitor;

    public AbstractComXervAmqpBackend(Session session, ComXervMarshaller marshaller, MessageSequenceCheck messageSequenceCheck, ApplicationContext appContext) throws LoginException {
        super(session, marshaller, messageSequenceCheck, appContext);
        this.applicationContext = appContext;
        this.lostHeartBeats = new AtomicInteger();
        this.firstHeartBeat = new AtomicInteger();
        this.lostHubToHubHeartBeats = new AtomicInteger();
        this.monitor = appContext.getService(Monitor.class);
    }

    protected abstract String getContentTypeHeartbeat();

    protected abstract String getContentTypeBroadcast();

    protected abstract String getContentError();

    protected abstract String getContentResponse();

    protected abstract String getHeaderGroupId();

    protected long getHub2HubHeartBeatInterval() {
        return 5000L;
    }

    private void checkHeartbeat() {
        if (this.disconnected()) {
            return;
        }
        if (this.getTimeService().getLocalTime().getMillis() - this.lastHeartbeatDate.getMillis() > 2L * this.heartbeatInterval + 1000L) {
            String text = Util.getLabel("comXervAmqpBackend_heartbeatLost", this.getSession().getExchange().getName());
            LOG.error(text);
            this.applicationContext.getService(InfoLogger.class).probeInternetConnectivity();
            this.applicationContext.getSmallDataModel(Message.class).handleBroadcastEntity(Message.createClientMessage(this.getSession().getExchange(), this.getTimeService().getLocalTime(), text, MessageSeverity.HIGH));
            if (this.lostHeartBeats.incrementAndGet() == 6) {
                this.notifyConnectionError(Util.getLabel("comXervAmqpBackend_heartbeatLost", this.getSession().getExchange().getName()));
            }
        }
    }

    private void checkHubToHubHeartbeat() {
        if (this.disconnected()) {
            this.notifyLostHubToHubHearbeat();
            return;
        }
        if (this.getTimeService().getLocalTime().getMillis() - this.lastHubToHubHeartbeatDate.getMillis() > 2L * this.getHub2HubHeartBeatInterval() + 1000L) {
            LOG.warn(Util.getLabel("comXervAmqpHubToHub_heartbeatLost"));
            if (this.lostHubToHubHeartBeats.incrementAndGet() >= 3) {
                this.notifyLostHubToHubHearbeat();
            }
        }
    }

    protected void reportMissingFirstHeartbeat() {
        if (this.disconnected()) {
            return;
        }
        String text = Util.getLabel("comXervAmqpBackend_missingFirstHeartbeat", this.getSession().getExchange().getName());
        LOG.error(text);
        this.applicationContext.getSmallDataModel(Message.class).handleBroadcastEntity(Message.createClientMessage(this.getSession().getExchange(), this.getTimeService().getLocalTime(), text, MessageSeverity.HIGH));
        if (this.firstHeartBeat.incrementAndGet() == 6) {
            this.notifyConnectionError(text);
        }
    }

    private void notifyLostHubToHubHearbeat() {
        Optional.ofNullable((HubToHubState)this.applicationContext.getSmallDataModel(HubToHubState.class).findById(0)).ifPresent(hubToHubState -> hubToHubState.setStatus(HubToHubStatus.LOST_HEARTBEAT));
    }

    @Override
    public void disconnect() {
        try {
            super.disconnect();
        }
        finally {
            if (this.heartbeatTask != null) {
                this.heartbeatTask.cancel(false);
            }
            if (this.hubToHubHeartbeatTask != null) {
                this.hubToHubHeartbeatTask.cancel(false);
            }
            if (this.firstHeartbeatTask != null) {
                this.firstHeartbeatTask.cancel(false);
            }
        }
    }

    @Override
    protected DateTime getServerTimestamp(AMQP.BasicProperties properties) {
        return DateTimeUtils.mapLongToDateTime(AmqpUtil.getServerTimestampHeaderFromProperties(properties), DateTimeZone.getDefault());
    }

    @Override
    protected void checkMessageDelay(AMQP.BasicProperties properties, int messageLength) {
        DateTime serverTimestamp;
        if (!this.isHeartbeatAndGroupIdIsLike(properties, "m7.heartbeat") && !this.isHeartbeatAndGroupIdIsLike(properties, "hubToHub") && (serverTimestamp = this.getServerTimestamp(properties)) != null) {
            long delta = this.getTimeService().getServerTime().getMillis() - serverTimestamp.getMillis();
            String type = properties.getType();
            if (Math.abs(delta) > 2000L) {
                this.monitor.largeMessageDelay(delta);
                LOG.warn("Large message delay detected: {}ms {}", (Object)delta, (Object)type);
            }
            if (PERFORMANCE_LOG.isDebugEnabled()) {
                Object groupId = properties.getHeaders().get(this.messageSequenceCheck.getGroupHeaderName());
                PERFORMANCE_LOG.debug(DELAY_MARKER, "{} {} {} {} {}", delta, type, messageLength, groupId, properties.getCorrelationId());
            }
        }
    }

    @Override
    public void processBroadcast(Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException, ClassNotFoundException {
        FxUtil.checkNotFxThread();
        this.lostHeartBeats.set(0);
        if (this.isHeartbeatAndGroupIdIsLike(properties, "m7.heartbeat")) {
            this.updateServerTime(properties);
            byte[] bodyBroadcast = AmqpUtil.decompressIfNeeded(properties, body, GZIP_COMPRESSION_ENCODING);
            String message = AmqpUtil.toString(bodyBroadcast);
            this.lastHeartbeatDate = this.getTimeService().getLocalTime();
            LOG.info(message);
            if (this.heartbeatInterval == -1L) {
                this.firstHeartbeatTask.cancel(false);
                this.heartbeatInterval = Long.parseLong(message.substring(message.indexOf(58) + 1));
                this.heartbeatTask = this.workerExecutorService.scheduleAtFixedRate(this::checkHeartbeat, 2L * this.heartbeatInterval + 1000L, 2L * this.heartbeatInterval, TimeUnit.MILLISECONDS);
            }
            this.monitor.connected(true);
            this.lostHeartBeats.set(0);
        } else if (this.isHeartbeatAndGroupIdIsLike(properties, "hubToHub")) {
            byte[] bodyBroadcast = AmqpUtil.decompressIfNeeded(properties, body, GZIP_COMPRESSION_ENCODING);
            this.lastHubToHubHeartbeatDate = this.getTimeService().getLocalTime();
            Object object = this.marshallObject(properties, bodyBroadcast);
            this.logBroadcast(object, properties);
            this.handleObject(object, properties.getCorrelationId(), AmqpUtil.getEventIndexHeaderFromProperties(properties));
            if (this.hubToHubHeartbeatTask == null) {
                this.hubToHubHeartbeatTask = this.workerExecutorService.scheduleAtFixedRate(this::checkHubToHubHeartbeat, 2L * this.getHub2HubHeartBeatInterval() + 1000L, 2L * this.getHub2HubHeartBeatInterval(), TimeUnit.MILLISECONDS);
            }
            this.lostHubToHubHeartBeats.set(0);
        } else {
            long unzipAndUnmarshall = System.currentTimeMillis();
            int sizeCompressed = body.length;
            byte[] bodyBroadcast = AmqpUtil.decompressIfNeeded(properties, body, GZIP_COMPRESSION_ENCODING);
            int sizeUncompressed = bodyBroadcast.length;
            bodyBroadcast = this.interceptMessage(bodyBroadcast, this.getServerTimestamp(properties), false, envelope.getRoutingKey(), properties.getCorrelationId(), AmqpUtil.getEventIndexHeaderFromProperties(properties));
            if (properties.getContentType().startsWith(this.getContentTypeBroadcast())) {
                Object object = this.marshallObject(properties, bodyBroadcast);
                this.logBroadcast(object, properties);
                this.logCompression(properties, object, sizeCompressed, sizeUncompressed, System.currentTimeMillis() - unzipAndUnmarshall);
                this.handleObject(object, properties.getCorrelationId(), AmqpUtil.getEventIndexHeaderFromProperties(properties));
            } else if (properties.getContentType().startsWith(this.getContentError())) {
                this.notifyException(new AbstractAmqpBackend.AmqpBackendException(AmqpUtil.toString(bodyBroadcast)));
            } else {
                this.notifyException(new AbstractAmqpBackend.AmqpBackendException("Unknown contentType: " + properties.getContentType()));
            }
        }
    }

    private Object marshallObject(AMQP.BasicProperties properties, byte[] bodyBroadcast) {
        Object object = null;
        try {
            object = this.getMarshaller().getObject(bodyBroadcast);
        }
        catch (MarshallerException e) {
            LOG.error(this.jaxbExceptionToString(properties, bodyBroadcast), e);
            this.notifyException(e);
        }
        return object;
    }

    @Override
    protected boolean hasMessageSequenceNumber(AMQP.BasicProperties properties) {
        return properties.getContentType().startsWith(this.getContentTypeHeartbeat()) || properties.getContentType().startsWith(this.getContentTypeBroadcast());
    }

    @Override
    protected ResponseWithCorrelationId sendRequest(byte[] message, String correlationId, String routingKey, int timeout, boolean retry, boolean handleErrResp, boolean compress, AtomicLong eventIndex) {
        FxUtil.checkNotFxThread();
        AmqpRpcClient amqpRpcClient = this.getAmqpRpcClient();
        if (amqpRpcClient != null) {
            try {
                byte[] body = this.interceptMessage(message, this.getTimeService().getLocalTime(), true, routingKey, correlationId, eventIndex != null ? Long.valueOf(eventIndex.get()) : null);
                AmqpRpcClient.RpcDelivery delivery = amqpRpcClient.sendMessage(routingKey, body, timeout, retry, correlationId, compress, eventIndex);
                if (delivery != null) {
                    DateTime serverTimestamp = this.getServerTimestamp(delivery.getProperties());
                    TimeService timeService = this.applicationContext.getService(TimeService.class);
                    if (serverTimestamp != null && !timeService.isInitialServerTimeSynchronizationDone()) {
                        this.updateServerTime(delivery.getProperties());
                    }
                    return this.handleDelivery(delivery, correlationId, handleErrResp);
                }
            }
            catch (RuntimeException e) {
                LOG.error(ERR_SEND_REQUEST_MSQ, e);
                this.notifyException(e);
                throw e;
            }
            catch (IOException e) {
                LOG.error(ERR_SEND_REQUEST_MSQ, e);
                this.notifyException(e);
                throw new AbstractAmqpBackend.AmqpBackendException("Request/response error. Correlation id = " + correlationId + ". " + e.getMessage(), e);
            }
        }
        return NULL_RESPONSE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ResponseWithCorrelationId handleDelivery(AmqpRpcClient.RpcDelivery delivery, String correlationId, boolean handleErrResp) throws IOException {
        AMQP.BasicProperties properties = delivery.getProperties();
        String respCorrelationId = properties.getCorrelationId();
        if (properties.getContentType().startsWith(this.getContentResponse())) {
            byte[] decompressedBody = AmqpUtil.decompressIfNeeded(properties, delivery.getBody(), GZIP_COMPRESSION_ENCODING);
            byte[] respBody = this.interceptMessage(decompressedBody, this.getServerTimestamp(properties), false, delivery.getEnvelope().getRoutingKey(), respCorrelationId, AmqpUtil.getEventIndexHeaderFromProperties(properties));
            Object response = this.unmarshalResponse(respBody, correlationId);
            if (!handleErrResp || !this.isErrorResponse(response)) return new SimpleResponseWithCorrelationId(response, respCorrelationId, AmqpUtil.getEventIndexHeaderFromProperties(properties), AmqpUtil.getPmiProcessingTimeHeaderFromProperties(properties));
            this.logErrorResponse(respCorrelationId, response.toString());
            this.handleObject(response, null, AmqpUtil.getEventIndexHeaderFromProperties(properties));
            return NULL_RESPONSE;
        } else if (properties.getContentType().startsWith(this.getContentError())) {
            byte[] decompressedBody = AmqpUtil.decompressIfNeeded(properties, delivery.getBody(), GZIP_COMPRESSION_ENCODING);
            String errorMessage = AmqpUtil.toString(decompressedBody);
            if (!handleErrResp) return new SimpleResponseWithCorrelationId(errorMessage, correlationId, AmqpUtil.getEventIndexHeaderFromProperties(properties), 0L);
            this.logErrorResponse(respCorrelationId, errorMessage);
            this.notifyException(new AbstractAmqpBackend.AmqpBackendException(errorMessage));
            return NULL_RESPONSE;
        } else {
            this.notifyException(new AbstractAmqpBackend.AmqpBackendException("Unknown contentType: " + properties.getContentType()));
        }
        return NULL_RESPONSE;
    }

    private Object unmarshalResponse(byte[] respBody, String correlationId) {
        try {
            return this.getMarshaller().getObject(respBody);
        }
        catch (MarshallerException e) {
            LOG.error(ERR_SEND_REQUEST_MSQ, e);
            if (respBody != null) {
                LOG.error("Wrong response: {}", (Object)AmqpUtil.toStringSwallowException(respBody));
            }
            this.notifyException(e);
            throw new AbstractAmqpBackend.AmqpBackendException("Request/response error. Correlation id = " + correlationId + ". " + e.getMessage(), e);
        }
    }

    protected abstract boolean isErrorResponse(Object var1);

    private void updateServerTime(AMQP.BasicProperties properties) {
        DateTime serverTimestamp = this.getServerTimestamp(properties);
        if (serverTimestamp != null) {
            this.getTimeService().updateServerTime(serverTimestamp);
        }
    }

    @Override
    public boolean handleAmqpConnectionError(Exception e) {
        if (this.userSuspended(e)) {
            this.handleUserChangeException(ErrorHandler.UserChangeType.SUSPENSION);
            return false;
        }
        if (this.userDeleted(e)) {
            this.handleUserChangeException(ErrorHandler.UserChangeType.DELETION);
            return false;
        }
        if (this.userPasswordReset(e)) {
            this.handleUserChangeException(ErrorHandler.UserChangeType.PASSWORD_RESET);
            return false;
        }
        if (this.userPasswordChangeError(e)) {
            this.handleUserChangeException(ErrorHandler.UserChangeType.PASSWORD_CHANGE_ERROR);
            return false;
        }
        if (this.userPasswordChange(e)) {
            this.handleUserChangeException(ErrorHandler.UserChangeType.PASSWORD_CHANGE);
            return false;
        }
        if (this.userAdminModification(e)) {
            this.handleUserChangeException(ErrorHandler.UserChangeType.ADMIN_MODIFICATION);
            return false;
        }
        if (this.accountAssignmentChange(e)) {
            this.handleUserChangeException(ErrorHandler.UserChangeType.ACCOUNT_CHANGE);
            return false;
        }
        if (this.connectionTerminatedByServer(e)) {
            this.handleUserChangeException(ErrorHandler.UserChangeType.CONNECTION_TERMINATED_BY_CORE);
            return false;
        }
        return super.handleAmqpConnectionError(e);
    }

    private boolean connectionTerminatedByServer(Exception e) {
        String shutdownReason = this.getShutdownReason(e);
        return this.isShutdownException(e) && shutdownReason.contains("CONNECTION_FORCED") && shutdownReason.contains("reply-code=320");
    }

    private boolean userSuspended(Exception e) {
        return this.isShutdownException(e) && this.getShutdownReason(e).contains("CONNECTION_FORCED - SUSPENDED");
    }

    private boolean userDeleted(Exception e) {
        return this.isShutdownException(e) && this.getShutdownReason(e).contains("CONNECTION_FORCED - ADMIN_DELETE");
    }

    private boolean userPasswordReset(Exception e) {
        return this.isShutdownException(e) && this.getShutdownReason(e).contains("CONNECTION_FORCED - PWD_RESET");
    }

    private boolean userPasswordChange(Exception e) {
        return this.isShutdownException(e) && this.getShutdownReason(e).contains("CONNECTION_FORCED - PWD_CHANGE");
    }

    private boolean userPasswordChangeError(Exception e) {
        return this.isShutdownException(e) && this.getShutdownReason(e).contains("CONNECTION_FORCED - PWD_CHANGE_ERROR");
    }

    private boolean accountAssignmentChange(Exception e) {
        return this.isShutdownException(e) && this.getShutdownReason(e).contains("CONNECTION_FORCED - ACCOUNT_ASSIGNMENT_CHANGE");
    }

    private boolean userAdminModification(Exception e) {
        String reason = this.getShutdownReason(e);
        return this.isShutdownException(e) && (reason.contains("CONNECTION_FORCED - ADMIN_MODIFICATION") || reason.contains("CONNECTION_FORCED - AMOD"));
    }

    private boolean isShutdownException(Exception e) {
        return e instanceof ShutdownSignalException;
    }

    private String getShutdownReason(Exception e) {
        if (this.isShutdownException(e)) {
            return String.valueOf(((ShutdownSignalException)e).getReason());
        }
        return "";
    }

    private boolean isHeartbeatAndGroupIdIsLike(AMQP.BasicProperties properties, String endsWith) {
        if (!properties.getContentType().startsWith(this.getContentTypeHeartbeat())) {
            return false;
        }
        Object groupIdHeader = properties.getHeaders().get(this.getHeaderGroupId());
        return groupIdHeader != null && groupIdHeader.toString().endsWith(endsWith);
    }

    @Override
    public void processBroadcastListener() {
        super.processBroadcastListener();
        if (this.heartbeatTask == null) {
            this.firstHeartbeatTask = this.workerExecutorService.scheduleAtFixedRate(this::reportMissingFirstHeartbeat, 5000L, 5000L, TimeUnit.MILLISECONDS);
        }
    }

    private static final class NullResponse
    implements ResponseWithCorrelationId {
        private NullResponse() {
        }

        @Override
        public String getCorrelationId() {
            return null;
        }

        @Override
        public Object getResponse() {
            return null;
        }

        @Override
        public Long getEventIndex() {
            return null;
        }

        @Override
        public Long getPmiProcessingTime() {
            return 0L;
        }
    }
}

