/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadSingleEntityTypeTask;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.DateTime;

public class LoadPublicTradeConfirmationsTask
extends LoadSingleEntityTypeTask<PublicTradeConfirmation> {
    public LoadPublicTradeConfirmationsTask(ComXervLoadContext loadContext) {
        super(loadContext, PublicTradeConfirmation.class);
    }

    @Override
    protected Set<PublicTradeConfirmation> load() {
        HashSet<PublicTradeConfirmation> result = new HashSet<PublicTradeConfirmation>();
        UserRoles userRoles = this.getLoadContext().getUserRoles();
        boolean hasProperRole = userRoles.isDataVendor() || userRoles.isTrader() || userRoles.isSalesUser() || userRoles.isAdmin() || userRoles.isBroker();
        AbstractComXervExchangeConnection connection = this.getLoadContext().getConnection();
        if (connection != null && hasProperRole) {
            DateTime endTime = this.getLoadContext().getServerTime().plusMinutes(10);
            DateTime startTime = endTime.minusHours(4);
            result.addAll(connection.getPublicTradeConfirmation(startTime, endTime));
        }
        return result;
    }
}

