/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.ComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeout;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.m7.trading.api.v6.AckResp;
import com.deutscheboerse.m7.trading.api.v6.ErrResp;
import com.deutscheboerse.m7.trading.api.v6.ErrorType;
import com.deutscheboerse.m7.trading.api.v6.StandardHeaderType;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComXervService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComXervService.class);
    private final BackendConnectionGateway backendConnectionGateway;
    private final OnBehalfService onBehalfService;

    protected AbstractComXervService(ApplicationContext applicationContext) {
        this.backendConnectionGateway = applicationContext.getService(BackendConnectionGateway.class);
        this.onBehalfService = applicationContext.getService(OnBehalfService.class);
    }

    protected void handleErrors(Stream<ErrorType> errors, ResponseHandler responseHandler) {
        if (this.getConnection() != null) {
            this.translateErrors(errors).forEach(responseHandler::handleResponse);
        }
    }

    protected Stream<AsyncResponse> translateErrors(Stream<ErrorType> errors) {
        MapperHandler mapper = this.getMapper();
        return mapper.translateStream(AsyncResponse.class, errors);
    }

    protected MapperHandler getMapper() {
        return this.getConnection().getMapper();
    }

    protected ExchangeConnection getConnection() {
        return this.backendConnectionGateway.getConnection();
    }

    protected Session getSession() {
        return this.backendConnectionGateway.getSession();
    }

    protected StandardHeaderType getStandardHeader() {
        return this.getStandardHeader(true, null);
    }

    protected StandardHeaderType getStandardHeader(User onBehalfUser) {
        return this.getStandardHeader(true, onBehalfUser);
    }

    protected StandardHeaderType getStandardHeader(boolean considerOnbehalf) {
        return this.getStandardHeader(considerOnbehalf, null);
    }

    protected StandardHeaderType getStandardHeader(boolean considerOnbehalf, User onBehalfUser) {
        ComXervExchangeConnection connection = (ComXervExchangeConnection)this.getConnection();
        StandardHeaderType standardHeader = connection.createStandardHeader();
        if (considerOnbehalf) {
            standardHeader.setOnBehalfUserId(onBehalfUser != null ? (Integer)onBehalfUser.getId() : this.onBehalfService.getOnBehalfUserId());
        }
        return standardHeader;
    }

    public boolean processImmediateServerResponse(Object response, ResponseHandler responseHandler) {
        boolean processFollowingMessages = false;
        if (response instanceof ErrResp) {
            ErrResp errResponse = (ErrResp)response;
            this.handleErrors(errResponse.getError().stream(), responseHandler);
        } else if (response instanceof Exception) {
            Exception exceptionResponse = (Exception)response;
            responseHandler.handleGeneralError(exceptionResponse.getMessage());
        } else if (response instanceof AckResp) {
            this.handleAcks(responseHandler);
            processFollowingMessages = true;
        } else {
            LOG.error("Unknown server response: {}", response);
        }
        if (!processFollowingMessages && responseHandler instanceof ResponseHandlerWithTimeout) {
            ResponseHandlerWithTimeout responseHandlerWithTimeout = (ResponseHandlerWithTimeout)responseHandler;
            responseHandlerWithTimeout.cancel();
        }
        return processFollowingMessages;
    }

    private void handleAcks(ResponseHandler responseHandler) {
        responseHandler.handleResponse(new AsyncResponse(ResponseStatus.ACKNOWLEDGED, null));
    }
}

