/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6;

import com.deutscheboerse.comxerv.comtrader.core.ExchangeSpecific;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpNames;
import com.google.inject.Singleton;
import java.util.List;
import java.util.stream.IntStream;

@Singleton
@ExchangeSpecific(apiVersion="v6")
public class ComXervAmqpNames
implements AmqpNames {
    private static final String BROADCAST_QUEUE = "m7.broadcastQueue.";
    private static final String RESPONSE_QUEUE_PATTERN = "m7.private.responseQueue.%s.queue";
    private static final String REQUEST_EXCHANGE = "m7.requestExchange.";

    @Override
    public String getBroadcastQueueName(String username) {
        return BROADCAST_QUEUE + username;
    }

    @Override
    public List<String> getResponseQueueNames(String username) {
        String formattedPattern = String.format(RESPONSE_QUEUE_PATTERN, username);
        return IntStream.range(1, 11).mapToObj(i -> formattedPattern + i).toList();
    }

    @Override
    public String getRequestExchangeName(String username) {
        return REQUEST_EXCHANGE + username;
    }

    @Override
    public String getInquiryRoutingKey() {
        return "m7.request.inquiry";
    }

    @Override
    public String getThrottlingInquiryRoutingKey() {
        return "m7.request.inquiry.throttling";
    }

    @Override
    public String getManagementRoutingKey() {
        return "m7.request.management";
    }
}

