/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.TradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.type.LimitType;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.m7.trading.api.v6.CommodityLmtType;

public class CommodityLimitMapper
extends AbstractMapper<CommodityLmtType, TradingLimit> {
    public CommodityLimitMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, CommodityLmtType.class, TradingLimit.class);
    }

    @Override
    public TradingLimit translate(CommodityLmtType from, MapperHandler mapperHandler, Object hint) {
        TradingLimit tradingLimit = new TradingLimit();
        tradingLimit.setLimitType(LimitType.CMDTY);
        tradingLimit.setMemberId(from.getMbrId());
        tradingLimit.setContractId(from.getContractId());
        Contract contract = (Contract)this.applicationContext.getSmallDataModel(Contract.class).findById(from.getContractId());
        tradingLimit.setContract(contract);
        tradingLimit.setId(from.getMbrId() + "|" + from.getContractId());
        if (contract == null) {
            tradingLimit.setInitial(new LongDisplayValue(from.getCommodityLmt(), 0));
        } else {
            Product product = contract.getProduct();
            tradingLimit.setInitial(product.mapPriceFromBackend(Long.valueOf(from.getCommodityLmt())));
        }
        return tradingLimit;
    }
}

