/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.entity.SystemInfo;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.m7.trading.api.type.SystemInfoCapabilities;
import com.deutscheboerse.m7.trading.api.v6.SystemInfoResp;
import org.joda.time.DateTimeZone;

public class SystemInfoMapper
extends AbstractMapper<SystemInfoResp, SystemInfo> {
    public SystemInfoMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, SystemInfoResp.class, SystemInfo.class);
    }

    @Override
    public SystemInfo translate(SystemInfoResp from, MapperHandler mapperHandler, Object hint) {
        SystemInfo.Builder builder = SystemInfo.newBuilder().withTimeZone(DateTimeZone.forID(from.getBackendMarketTimeZone())).withBackendVersion(from.getBackendVersion()).withCurrentComtraderVersion(from.getAppVersionActual()).withContractStoreTimeInDays(this.getContractStoreInDaysForUser(from)).withMaxOrders(from.getMaxOrders()).withAllowedClearingAccountTypes(from.getAllowedClearingAcctTypes());
        if (from.getCapabilities().contains(SystemInfoCapabilities.PNC_ORDERS.getValue())) {
            builder.withPncOrders();
        }
        if (from.getCapabilities().contains(SystemInfoCapabilities.QUOTE_REQUESTS.getValue())) {
            builder.withQuoteRequests();
        }
        if (from.getCapabilities().contains(SystemInfoCapabilities.TRADING_LIMIT.getValue())) {
            builder.withTradingLimit();
        }
        if (from.getCapabilities().contains(SystemInfoCapabilities.OPEN_CLOSE_INDICATOR.getValue())) {
            builder.withOpenCloseIndicator();
        }
        if (from.getCapabilities().contains(SystemInfoCapabilities.LOCAL_EXCHANGE.getValue())) {
            builder.withLocalExchange();
        }
        if (from.getCapabilities().contains(SystemInfoCapabilities.SETTLEMENT.getValue())) {
            builder.withSettlement();
        }
        if (from.getCapabilities().contains(SystemInfoCapabilities.SETTLEMENT_INFO_FOR_TRADER.getValue())) {
            builder.withSettlementInfoForTrader();
        }
        if (from.getCapabilities().contains(SystemInfoCapabilities.LOCATIONS.getValue())) {
            builder.withLocations();
        }
        return builder.build();
    }

    private int getContractStoreInDaysForUser(SystemInfoResp systemInfoResp) {
        if (this.applicationContext.getService(UserService.class).getOwnUser().getRoles().isAdmin()) {
            return this.getContractStoreInDaysForParam(systemInfoResp, "contractStoreTimeInDaysAdminLimit");
        }
        return this.getContractStoreInDaysForParam(systemInfoResp, "contractStoreTimeInDaysLimit");
    }

    private int getContractStoreInDaysForParam(SystemInfoResp from, String appParam) {
        int contractStoreTimeInDaysLimit = this.applicationContext.getService(ApplicationConfigurationService.class).getIntegerApplicationProperty(appParam, Integer.MAX_VALUE);
        return Math.min(from.getContractStoreTimeInDays(), contractStoreTimeInDaysLimit);
    }
}

