/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.core;

import com.deutscheboerse.comxerv.comtrader.configuration.ExchangeConfiguration;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.javabean.JavaBeanConverter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.security.NoTypePermission;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeConfigurationLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ExchangeConfigurationLoader.class);

    public void load() {
        try {
            Exchange.add(this.createExchange(this.loadConfiguration()));
        }
        catch (Exception e) {
            LOG.error("Could not load exchanges.", e);
        }
    }

    private Exchange createExchange(ExchangeConfiguration configuration) {
        return Exchange.newBuilder().withMarketId(configuration.getMarketId()).withName(configuration.getName()).withApiVersion(configuration.getApiVersion()).withContractLookAheadInDays(configuration.getContractLookAheadInDays()).withSupportsCommodityLimit(configuration.isSupportsCommodityLimit()).withSupportsLogoutAction(configuration.isSupportsLogoutAction()).withSupportsAuction(configuration.isSupportsAuction()).withSupportsDeliveryAreas(configuration.isSupportsDeliveryAreas()).withCustomTrustStore(configuration.getCustomTrustStore()).withCustomTrustStorePassword(configuration.getCustomTrustStorePassword()).build();
    }

    private ExchangeConfiguration loadConfiguration() throws IOException {
        XStream xstream = this.buildXStream();
        try (InputStream exchangeResource = ExchangeConfigurationLoader.class.getResourceAsStream("/exchange.xml");){
            if (exchangeResource == null) {
                throw new IOException("Unable to load exchange.xml file from the classpath.");
            }
            ExchangeConfiguration exchangeConfiguration = (ExchangeConfiguration)xstream.fromXML(exchangeResource);
            return exchangeConfiguration;
        }
    }

    private XStream buildXStream() {
        XStream xstream = new XStream(new DomDriver());
        xstream.addPermission(NoTypePermission.NONE);
        xstream.allowTypes(new Class[]{ExchangeConfiguration.class});
        xstream.alias("ExchangeConfiguration", ExchangeConfiguration.class);
        xstream.registerConverter(new JavaBeanConverter(xstream.getMapper(), ExchangeConfiguration.class));
        xstream.ignoreUnknownElements();
        return xstream;
    }
}

