/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.DataModelFactory;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.datamodel.BalancingGroupDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.ContractDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.CurrentTradingLimitDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.DeliveryAreaDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.FullTradeDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.H2HAreaDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.HubToHubDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.HubToHubStateDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.MarketAreaDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.MarketStateDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.MemberDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.MessageDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.OrderDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.OrderLimitDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.OrderbookDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.ProductDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.PublicTradeConfirmationDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.RiskSetDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.TradingLimitDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.UserDataModel;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.CurrentTradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.H2HArea;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHub;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHubState;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.entities.MarketState;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.OrderLimit;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.entities.RiskSet;
import com.deutscheboerse.comxerv.comtrader.entities.TradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.google.inject.Singleton;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DataModelFactoryImpl
implements DataModelFactory {
    private final Map<Class<? extends BroadcastEntity>, Class<? extends DataModel<?, ? extends BroadcastEntity>>> models = new HashMap();
    private static final Logger LOG = LoggerFactory.getLogger(DataModelFactoryImpl.class);

    public DataModelFactoryImpl() {
        this.models.put(Message.class, MessageDataModel.class);
        this.models.put(MarketState.class, MarketStateDataModel.class);
        this.models.put(TradingLimit.class, TradingLimitDataModel.class);
        this.models.put(CurrentTradingLimit.class, CurrentTradingLimitDataModel.class);
        this.models.put(OrderLimit.class, OrderLimitDataModel.class);
        this.models.put(BalancingGroup.class, BalancingGroupDataModel.class);
        this.models.put(Product.class, ProductDataModel.class);
        this.models.put(MarketArea.class, MarketAreaDataModel.class);
        this.models.put(DeliveryArea.class, DeliveryAreaDataModel.class);
        this.models.put(Contract.class, ContractDataModel.class);
        this.models.put(Order.class, OrderDataModel.class);
        this.models.put(Orderbook.class, OrderbookDataModel.class);
        this.models.put(FullTrade.class, FullTradeDataModel.class);
        this.models.put(PublicTradeConfirmation.class, PublicTradeConfirmationDataModel.class);
        this.models.put(HubToHub.class, HubToHubDataModel.class);
        this.models.put(Member.class, MemberDataModel.class);
        this.models.put(User.class, UserDataModel.class);
        this.models.put(RiskSet.class, RiskSetDataModel.class);
        this.models.put(HubToHubState.class, HubToHubStateDataModel.class);
        this.models.put(H2HArea.class, H2HAreaDataModel.class);
    }

    @Override
    public <I extends Comparable<I>, T extends BroadcastEntity<I>> DataModel<I, T> createDataModel(ApplicationContext applicationContext, Class<T> forEntityClass) {
        Class<DataModel<?, BroadcastEntity>> modelClass = this.models.get(forEntityClass);
        try {
            Constructor<DataModel<?, BroadcastEntity>> constructor = modelClass.getConstructor(ApplicationContext.class);
            return constructor.newInstance(applicationContext);
        }
        catch (Exception e) {
            LOG.error("Could not initialize DataModel for " + forEntityClass.getSimpleName(), e);
            throw new IllegalStateException(e);
        }
    }
}

