/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.EntityFilters;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.SmallFastDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.SortedSmallFastDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.domain.query.BalancingGroupQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.SuspensionType;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Set;

@Singleton
class BalancingGroupQueriesImpl
implements BalancingGroupQueries {
    private final SmallFastDataModel<String, BalancingGroup> dataModel;

    @Inject
    public BalancingGroupQueriesImpl(ApplicationContext applicationContext) {
        this.dataModel = applicationContext.getSmallDataModel(BalancingGroup.class);
    }

    @Override
    public DataQuery<BalancingGroup> findActiveOtcForProductId(Product product) {
        return new SortedSmallFastDataModelQuery<String, BalancingGroup>(this.dataModel, BalancingGroup::compareTo).addFilter(EntityFilters.propertyEquals(BalancingGroup::isOtcTrading, true)).addFilter(EntityFilters.propertyEquals(BalancingGroup::getSuspensionType, SuspensionType.ACTIVE)).addFilter(bg -> bg.getProductIds().contains(product.getId()));
    }

    @Override
    public DataQuery<BalancingGroup> findByName(String name) {
        return new SmallFastDataModelQuery<String, BalancingGroup>(this.dataModel).addFilter(EntityFilters.propertyEquals(BalancingGroup::getName, name));
    }

    @Override
    public DataQuery<BalancingGroup> findByIds(Set<String> balancingGroupIds) {
        return new SmallFastDataModelQuery<String, BalancingGroup>(this.dataModel).addFilter(bg -> balancingGroupIds.contains(bg.getId()));
    }
}

