/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.EntityFilters;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.SmallFastDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.SortedSmallFastDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.domain.filter.ContractFilters;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BespokeContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.PutOrCall;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;

@Singleton
class ContractQueriesImpl
implements ContractQueries {
    private final SmallFastDataModel<Long, Contract> dataModel;

    @Inject
    public ContractQueriesImpl(ApplicationContext applicationContext) {
        this.dataModel = applicationContext.getSmallDataModel(Contract.class);
    }

    @Override
    public DataQuery<Contract> findByProduct(Product product) {
        return new SmallFastDataModelQuery<Long, Contract>(this.dataModel).addFilter(EntityFilters.propertyEquals(Contract::getProduct, product));
    }

    @Override
    public Optional<Contract> findByRemoteContractId(Long remoteContractId) {
        return new SmallFastDataModelQuery<Long, Contract>(this.dataModel).addFilter(EntityFilters.propertyEquals(Contract::getRemoteContractId, remoteContractId)).getFirst();
    }

    @Override
    public DataQuery<Contract> findByName(String name) {
        return new SortedSmallFastDataModelQuery<Long, Contract>(this.dataModel, this.getContractStatusComparator().reversed()).addFilter(EntityFilters.propertyEquals(Contract::getName, name));
    }

    @Override
    public DataQuery<Contract> findActiveByName(String name) {
        return this.findByName(name).addFilter(ContractFilters.ACTIVE);
    }

    @Override
    public DataQuery<Contract> findByNameContainsIgnoreCase(String namePrefix) {
        return new SmallFastDataModelQuery<Long, Contract>(this.dataModel).addFilter(EntityFilters.containsIgnoreCase(Contract::getName, namePrefix));
    }

    private Comparator<Contract> getContractStatusComparator() {
        return (c1, c2) -> ObjectUtils.compare(c1.getCompoundStatus().getContractStatus().ordinal(), c2.getCompoundStatus().getContractStatus().ordinal());
    }

    @Override
    public DataQuery<Contract> findPossibleUnderlyingContracts(Product product) {
        return this.findByProduct(product).addFilter(ContractFilters.ACTIVE).addFilter(c -> c.getProduct().isOnExchangePrearrangedTrade()).addFilter(c -> !(c instanceof BespokeContract));
    }

    @Override
    public DataQuery<BespokeContract> findActiveBespokeContracts() {
        return this.findBespokeContracts().addFilter(c -> c.getCompoundStatus().getContractStatus().isActive());
    }

    @Override
    public DataQuery<BespokeContract> findByUnderlyingContracts(List<Contract> underlyingContracts) {
        return this.findBespokeContracts().addFilter(bespokeContract -> bespokeContract.getUnderlyingContracts().size() == underlyingContracts.size() && bespokeContract.getUnderlyingContracts().containsAll(underlyingContracts));
    }

    @Override
    public DataQuery<BespokeContract> findByUnderlyingContractsAndOption(List<Contract> underlyingContracts, LongDisplayValue strikePrc, PutOrCall putOrCall) {
        return this.findBespokeContracts().addFilter(EntityFilters.propertyEquals(Contract::getStrikePrc, strikePrc)).addFilter(EntityFilters.propertyEquals(Contract::getPutOrCall, putOrCall)).addFilter(bespokeContract -> bespokeContract.getUnderlyingContracts().size() == underlyingContracts.size() && bespokeContract.getUnderlyingContracts().containsAll(underlyingContracts));
    }

    private DataQuery<BespokeContract> findBespokeContracts() {
        return new SmallFastDataModelQuery<Long, Contract>(this.dataModel).filterAndCast(BespokeContract.class);
    }
}

