/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderLimitQueries;
import com.deutscheboerse.comxerv.comtrader.entities.OrderLimit;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Optional;

@Singleton
class OrderLimitQueriesImpl
implements OrderLimitQueries {
    private final SmallFastDataModel<Long, OrderLimit> orderLimitDataModel;

    @Inject
    public OrderLimitQueriesImpl(ApplicationContext applicationContext) {
        this.orderLimitDataModel = applicationContext.getSmallDataModel(OrderLimit.class);
    }

    @Override
    public Optional<OrderLimit> findOrderLimitForProduct(Product product) {
        return this.orderLimitDataModel.getAllEntitiesAsStream().filter(orderLimit -> product.equals(orderLimit.getProduct())).findFirst();
    }
}

