/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.EntityFilters;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.SmallFastDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BlockContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.PersistentOrderbookId;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@Singleton
class OrderbookQueriesImpl
implements OrderbookQueries {
    private final SmallFastDataModel<String, Orderbook> orderbookDataModel;
    private final Map<DeliveryAreaContractIndexKey, Orderbook> exchangeDeliveryAreaContractIndex;
    private final Map<Long, List<Orderbook>> contractIdIndex;

    @Inject
    public OrderbookQueriesImpl(ApplicationContext applicationContext) {
        this.orderbookDataModel = applicationContext.getSmallDataModel(Orderbook.class);
        this.exchangeDeliveryAreaContractIndex = new ConcurrentHashMap<DeliveryAreaContractIndexKey, Orderbook>();
        this.contractIdIndex = new ConcurrentHashMap<Long, List<Orderbook>>();
        this.orderbookDataModel.registerHencePostOperationListener((DataModelListener<Orderbook>)new AbstractDataModelListener<Orderbook>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(Orderbook object) {
                OrderbookQueriesImpl.this.exchangeDeliveryAreaContractIndex.put(new DeliveryAreaContractIndexKey(object), object);
                OrderbookQueriesImpl.this.contractIdIndex.computeIfAbsent(object.getContractId(), cid -> new CopyOnWriteArrayList()).add(object);
                return super.notifyAdd(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemove(Orderbook object) {
                OrderbookQueriesImpl.this.exchangeDeliveryAreaContractIndex.remove(new DeliveryAreaContractIndexKey(object));
                OrderbookQueriesImpl.this.contractIdIndex.computeIfPresent(object.getContractId(), (cid, obks) -> {
                    obks.remove(object);
                    return obks;
                });
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                OrderbookQueriesImpl.this.exchangeDeliveryAreaContractIndex.clear();
                OrderbookQueriesImpl.this.contractIdIndex.clear();
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        });
    }

    @Override
    public Optional<Orderbook> findByPersistentOrderbookId(PersistentOrderbookId persistentOrderbookId) {
        return new SmallFastDataModelQuery<String, Orderbook>(this.orderbookDataModel).addFilter(EntityFilters.propertyNotNull(Orderbook::getContract)).addFilter(EntityFilters.propertyEquals(orderbook -> orderbook.getContract().getName(), persistentOrderbookId.getContractName())).addFilter(EntityFilters.propertyNotNull(orderbook -> orderbook.getContract().getProduct())).addFilter(EntityFilters.propertyEquals(orderbook -> orderbook.getContract().getProduct().getName(), persistentOrderbookId.getProductName())).addFilter(EntityFilters.propertyEquals(Orderbook::getDeliveryAreaId, persistentOrderbookId.getDeliveryAreaId())).getFirst();
    }

    @Override
    public List<Orderbook> findByContract(Contract contract) {
        return contract == null ? Collections.emptyList() : Collections.unmodifiableList(this.contractIdIndex.getOrDefault(contract.getId(), Collections.emptyList()));
    }

    @Override
    public DataQuery<Orderbook> findByProductIdAndDeliveryArea(String productId, String deliveryAreaId) {
        return new SmallFastDataModelQuery<String, Orderbook>(this.orderbookDataModel).addFilter(EntityFilters.propertyEquals(Orderbook::getDeliveryAreaId, deliveryAreaId)).addFilter(orderbook -> ((String)orderbook.getContract().getProduct().getId()).equals(productId));
    }

    @Override
    public Optional<Orderbook> findByContractAndDeliveryArea(Contract contract, DeliveryArea deliveryArea) {
        if (contract == null || deliveryArea == null) {
            return Optional.empty();
        }
        return this.findByContractIdAndDeliveryAreaId((Long)contract.getId(), (String)deliveryArea.getId());
    }

    @Override
    public Optional<Orderbook> findByOrder(Order order) {
        return this.findByContractIdAndDeliveryAreaId(order.getContractId(), order.getDeliveryAreaId());
    }

    @Override
    public Optional<Orderbook> findByContractIdAndDeliveryAreaId(Long contractId, String deliveryAreaId) {
        DeliveryAreaContractIndexKey indexKey = new DeliveryAreaContractIndexKey(contractId, deliveryAreaId);
        return Optional.ofNullable(this.exchangeDeliveryAreaContractIndex.get(indexKey));
    }

    @Override
    public List<Orderbook> findByUnderlyingContractAndDeliveryArea(Contract underlyingContract, DeliveryArea deliveryArea) {
        return this.orderbookDataModel.getAllEntitiesAsStream().filter(EntityFilters.propertyEquals(Orderbook::getDeliveryAreaId, (String)deliveryArea.getId())).filter(orderbook -> orderbook.getContract().getType().isBlock()).filter(orderbook -> OrderbookQueriesImpl.isForUderlyingContract(orderbook, underlyingContract)).toList();
    }

    private static boolean isForUderlyingContract(Orderbook orderbook, Contract underlyingContract) {
        Contract contract = orderbook.getContract();
        if (contract instanceof BlockContract) {
            return ((BlockContract)contract).getUnderlyingContracts().contains(underlyingContract);
        }
        return false;
    }

    private static final class DeliveryAreaContractIndexKey {
        private final Long contractId;
        private final String deliveryAreaId;

        private DeliveryAreaContractIndexKey(Long contractId, String deliveryAreaId) {
            this.contractId = contractId;
            this.deliveryAreaId = deliveryAreaId;
        }

        private DeliveryAreaContractIndexKey(Orderbook orderbook) {
            this.contractId = orderbook.getContractId();
            this.deliveryAreaId = orderbook.getDeliveryAreaId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeliveryAreaContractIndexKey that = (DeliveryAreaContractIndexKey)o;
            return Objects.equals(this.contractId, that.contractId) && Objects.equals(this.deliveryAreaId, that.deliveryAreaId);
        }

        public int hashCode() {
            return Objects.hash(this.contractId, this.deliveryAreaId);
        }
    }
}

