/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.entities.BlockContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.TimeStampProvider;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import org.joda.time.DateTime;

public class BasketEntry
implements TimeStampProvider {
    private final Order order;
    private final DateTime timeStamp;

    public BasketEntry(Order order, DateTime timeStamp) {
        this.order = this.preprocessOrder(order);
        this.timeStamp = timeStamp;
    }

    private Order preprocessOrder(Order order) {
        Order processedOrder = new Order(order);
        if (processedOrder.getValidityRestriction() == ValidityRestriction.GOOD_FOR_SESSION || processedOrder.getValidityRestriction() == ValidityRestriction.NONE) {
            processedOrder.setValidityDate(null);
        }
        processedOrder.setId(null);
        processedOrder.setInitialOrderId(null);
        processedOrder.initNewClientOrderId();
        return processedOrder;
    }

    public Order getOrder() {
        return this.order;
    }

    public String getContractName() {
        Contract contract = this.getOrder().getContract();
        if (contract instanceof BlockContract) {
            return ((BlockContract)contract).getFrontContract().getName();
        }
        return contract == null ? "" : contract.getName();
    }

    public String getRearContractName() {
        Contract contract = this.getOrder().getContract();
        if (contract instanceof BlockContract) {
            return ((BlockContract)contract).getRearContract().getName();
        }
        return "";
    }

    public String getProductName() {
        Contract contract = this.getOrder().getContract();
        return contract == null ? "" : contract.getProduct().getName();
    }

    @Override
    public DateTime getTimeStamp() {
        return this.timeStamp;
    }
}

