/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractType;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BespokeContract
extends Contract {
    private final Function<Long, Contract> contractResolver;
    private final List<Long> underlyingContracts;

    public BespokeContract(Product product, List<Long> underlyingContracts, Function<Long, Contract> contractResolver) {
        super(product);
        this.underlyingContracts = underlyingContracts;
        this.contractResolver = contractResolver;
    }

    public List<Contract> getUnderlyingContracts() {
        return this.underlyingContracts.stream().map(this.contractResolver).toList();
    }

    @Override
    public String toString() {
        return "BespokeContract{id=" + String.valueOf(this.getId()) + ",name=" + this.getName() + ", underlyingContracts= " + this.underlyingContracts.stream().map(Object::toString).collect(Collectors.joining(",")) + "}";
    }

    @Override
    public ContractType getType() {
        return ContractType.BESPOKE;
    }
}

