/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductType;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class BlockContract
extends Contract {
    private Contract frontContract;
    private Contract rearContract;
    private final Supplier<Stream<Contract>> underlyingContracts;

    public BlockContract(Product product, Supplier<Stream<Contract>> underlyingContracts) {
        super(product);
        this.underlyingContracts = underlyingContracts;
    }

    @Override
    public double getDeliveryUnits() {
        return this.getUnderlyingContracts().stream().mapToDouble(Contract::getDeliveryUnits).sum();
    }

    public Contract getFrontContract() {
        if (this.frontContract == null) {
            this.frontContract = this.underlyingContracts.get().min(this::compareContract).orElse(null);
        }
        return this.frontContract;
    }

    public Contract getRearContract() {
        if (this.rearContract == null) {
            this.rearContract = this.underlyingContracts.get().max(this::compareContract).orElse(null);
        }
        return this.rearContract;
    }

    public List<Contract> getUnderlyingContracts() {
        return this.underlyingContracts.get().sorted(this::compareContract).toList();
    }

    private int compareContract(Contract c1, Contract c2) {
        return c1.getDeliveryStart().compareTo(c2.getDeliveryStart());
    }

    @Override
    public String toString() {
        return "BlockContract{id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", frontContract= " + this.getContractName(this.getFrontContract()) + ", rearContract= " + this.getContractName(this.getRearContract()) + "}";
    }

    private String getContractName(Contract contract) {
        return contract == null ? null : contract.getName();
    }

    @Override
    public ContractType getType() {
        return this.getProductType() == ProductType.USER_DEFINED_DELIVERY_PERIOD ? ContractType.UDDP : ContractType.UDB;
    }
}

