/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.RevisionNumbered;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductState;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductType;
import com.deutscheboerse.ui.jfx.util.binding.ConstantStringProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javafx.beans.property.StringProperty;

public class Product
extends BroadcastEntity<String>
implements RevisionNumbered,
Comparable<Product>,
SmallDataModelEntity,
DisplayName {
    public static final Comparator<Product> DEFAULT_DISPLAY_COMPARATOR = Comparator.comparing(p -> p.getDisplayName().toUpperCase(Locale.ENGLISH));
    private final Exchange exchange;
    private final String globalMarketId;
    private final String displayName;
    private final StringProperty displayNameProperty;
    private final long revisionNumber;
    private final String currencyCode;
    private final String quantityUnit;
    private final int priceDecimalShift;
    private final LongDisplayValue priceTickSize;
    private final LongDisplayValue priceMinValue;
    private final LongDisplayValue priceMaxValue;
    private final int quantityDecimalShift;
    private final LongDisplayValue quantityLotSize;
    private final LongDisplayValue quantityMinValue;
    private final LongDisplayValue quantityMaxValue;
    private final LongDisplayValue amountMaxValue;
    private final double deliveryUnits;
    private final String timeZone;
    private final int priceDecimalShiftForBackend;
    private final int quantityDecimalShiftForBackend;
    private final ProductType productType;
    private final ProductState productState;
    private final boolean isBaseProduct;
    private final boolean isLocationsEnabled;
    private final String baseProductId;
    private final String groupName;
    private final ProductExecutionRestriction executionRestriction;
    private final String masterProductId;
    private final String linkedProductId;
    private final LongDisplayValue icebergMinPeakSize;
    private final LongDisplayValue icebergDeltaRange;
    private final LongDisplayValue minQuoteQuantity;
    private final boolean icebergOrdersSupported;
    private final boolean liftOrderProduct;
    private final boolean linkedOrdersSupported;
    private final boolean onExchangePrearrangedTrades;
    private final boolean otcOnly;
    private final boolean otcSupported;
    private final boolean stopOrdersSuppored;
    private final boolean privateAndConfidential;
    private final boolean quoteOrderProduct;
    private final boolean blockOrderProduct;
    private final boolean aotEnabled;
    private final Long riskSetId;

    public Product(ProductBuilder builder) {
        this.setId(builder.id);
        this.exchange = builder.exchange;
        this.globalMarketId = builder.globalMarketId;
        this.displayName = builder.displayName;
        this.displayNameProperty = new ConstantStringProperty(this.displayName);
        this.revisionNumber = builder.revisionNumber;
        this.currencyCode = builder.currencyCode;
        this.quantityUnit = builder.quantityUnit;
        this.priceDecimalShift = builder.priceDecimalShift;
        this.priceTickSize = builder.priceTickSize;
        this.priceMinValue = builder.priceMinValue;
        this.priceMaxValue = builder.priceMaxValue;
        this.quantityDecimalShift = builder.quantityDecimalShift;
        this.quantityLotSize = builder.quantityLotSize;
        this.quantityMinValue = builder.quantityMinValue;
        this.quantityMaxValue = builder.quantityMaxValue;
        this.amountMaxValue = builder.amountMaxValue;
        this.deliveryUnits = builder.deliveryUnits;
        this.timeZone = builder.timeZone;
        this.priceDecimalShiftForBackend = builder.priceDecimalShiftForBackend;
        this.quantityDecimalShiftForBackend = builder.quantityDecimalShiftForBackend;
        this.productType = builder.productType;
        this.productState = builder.productState;
        this.isBaseProduct = builder.isBaseProduct;
        this.isLocationsEnabled = builder.isLocationsEnabled;
        this.baseProductId = builder.baseProductId;
        this.groupName = builder.groupName;
        this.executionRestriction = builder.executionRestriction;
        this.masterProductId = builder.masterProductId;
        this.linkedProductId = builder.linkedProductId;
        this.icebergMinPeakSize = new LongDisplayValue(builder.icebergMinPeakSize, this.quantityDecimalShift);
        this.icebergDeltaRange = new LongDisplayValue(builder.icebergDeltaRange, this.priceDecimalShift);
        this.minQuoteQuantity = new LongDisplayValue(builder.minQuoteQuantity, this.quantityDecimalShift);
        this.icebergOrdersSupported = builder.icebergOrdersSupported;
        this.liftOrderProduct = builder.liftOrderProduct;
        this.linkedOrdersSupported = builder.linkedOrdersSupported;
        this.onExchangePrearrangedTrades = builder.onExchangePrearrangedTrades;
        this.otcOnly = builder.otcOnly;
        this.otcSupported = builder.otcSupported;
        this.stopOrdersSuppored = builder.stopOrdersSupported;
        this.privateAndConfidential = builder.privateAndConfidential;
        this.quoteOrderProduct = builder.quoteOrderProduct;
        this.blockOrderProduct = builder.blockOrderProduct;
        this.aotEnabled = builder.aotEnabled;
        this.riskSetId = builder.riskSetId;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    @Override
    public Class<Product> getEntityClass() {
        return Product.class;
    }

    public String getName() {
        return (String)this.getId();
    }

    public String getGlobalMarketId() {
        return this.globalMarketId;
    }

    public boolean isGlobalProduct() {
        return this.getId() != null && !this.exchange.getMarketId().equals(this.globalMarketId);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public int compareTo(Product o) {
        return ((String)this.getId()).compareTo((String)o.getId());
    }

    public boolean isLinkedOrderProduct() {
        return this.linkedOrdersSupported;
    }

    public boolean isStopOrderSupported() {
        return this.stopOrdersSuppored;
    }

    public boolean isOtcOnlyProduct() {
        return this.otcOnly;
    }

    public boolean isOtcTradingSupported() {
        return this.otcSupported;
    }

    public boolean isIcebergOrdersSupported() {
        return this.icebergOrdersSupported;
    }

    public boolean isQuoteOrderProduct() {
        return this.quoteOrderProduct;
    }

    public boolean isBlockOrderProduct() {
        return this.blockOrderProduct;
    }

    public boolean isAotEnabled() {
        return this.aotEnabled;
    }

    public boolean isLiftOrderProduct() {
        return this.liftOrderProduct;
    }

    public boolean isPrivateAndConfidential() {
        return this.privateAndConfidential;
    }

    public boolean isOnExchangePrearrangedTrade() {
        return this.onExchangePrearrangedTrades;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public StringProperty displayNameProperty() {
        return this.displayNameProperty;
    }

    @Override
    public long getRevisionNumber() {
        return this.revisionNumber;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getQuantityUnit() {
        return this.quantityUnit;
    }

    public int getPriceDecimalShift() {
        return this.priceDecimalShift;
    }

    public LongDisplayValue getPriceTickSize() {
        return this.priceTickSize;
    }

    public LongDisplayValue getPriceMinValue() {
        return this.priceMinValue;
    }

    public LongDisplayValue getPriceMaxValue() {
        return this.priceMaxValue;
    }

    public int getQuantityDecimalShift() {
        return this.quantityDecimalShift;
    }

    public LongDisplayValue getQuantityLotSize() {
        return this.quantityLotSize;
    }

    public LongDisplayValue getQuantityMinValue() {
        return this.quantityMinValue;
    }

    public LongDisplayValue getQuantityMaxValue() {
        return this.quantityMaxValue;
    }

    public LongDisplayValue getAmountMaxValue() {
        return this.amountMaxValue;
    }

    public Map<String, Object> getProductConfig() {
        return Collections.emptyMap();
    }

    public double getDeliveryUnits() {
        return this.deliveryUnits;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public int getPriceDecimalShiftForBackend() {
        return this.priceDecimalShiftForBackend;
    }

    public int getQuantityDecimalShiftForBackend() {
        return this.quantityDecimalShiftForBackend;
    }

    public Long getRiskSetId() {
        return this.riskSetId;
    }

    public Integer mapQuantityToBackend(LongDisplayValue quantity) {
        if (quantity == null) {
            return null;
        }
        return (int)quantity.applyShift(this.getQuantityDecimalShiftForBackend()).getValue();
    }

    public Long mapPriceToBackend(LongDisplayValue price) {
        if (price == null) {
            return null;
        }
        return price.applyShift(this.getPriceDecimalShiftForBackend()).getValue();
    }

    public LongDisplayValue mapQuantityFromBackend(Long quantity) {
        Integer quantityInt = quantity == null ? null : Integer.valueOf(quantity.intValue());
        return this.mapQuantityFromBackend(quantityInt);
    }

    public LongDisplayValue mapQuantityFromBackend(Integer quantity) {
        if (quantity == null) {
            return null;
        }
        return new LongDisplayValue(quantity.intValue(), this.getQuantityDecimalShiftForBackend()).applyShift(this.getQuantityDecimalShift());
    }

    public LongDisplayValue mapPriceFromBackend(Long price) {
        if (price == null) {
            return null;
        }
        return new LongDisplayValue(price, this.getPriceDecimalShiftForBackend()).applyShift(this.getPriceDecimalShift());
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public ProductState getProductState() {
        return this.productState;
    }

    public boolean hasRelevantProductSetupChanges(Product other) {
        return !Objects.equals(this.getDisplayName(), other.getDisplayName()) || !this.getPriceMinValue().equals(other.getPriceMinValue()) || !this.getPriceMaxValue().equals(other.getPriceMaxValue()) || !this.getPriceTickSize().equals(other.getPriceTickSize()) || !this.getQuantityMinValue().equals(other.getQuantityMinValue()) || !this.getQuantityMaxValue().equals(other.getQuantityMaxValue()) || !this.getAmountMaxValue().equals(other.getAmountMaxValue()) || !this.getQuantityLotSize().equals(other.getQuantityLotSize()) || this.getPriceDecimalShift() != other.getPriceDecimalShift() || this.getQuantityDecimalShift() != other.getQuantityDecimalShift() || !Objects.equals(this.getQuantityLotSize(), other.getQuantityLotSize()) || this.getPriceDecimalShiftForBackend() != other.getPriceDecimalShiftForBackend() || this.getQuantityDecimalShiftForBackend() != other.getQuantityDecimalShiftForBackend() || this.getProductType() != other.getProductType() || this.isBaseProduct != other.isBaseProduct || this.isLocationsEnabled != other.isLocationsEnabled || !Objects.equals(this.getBaseProductId(), other.getBaseProductId()) || !Objects.equals(this.getGroupName(), other.getGroupName()) || this.getExecutionRestriction() != other.getExecutionRestriction() || this.getDeliveryUnits() != other.getDeliveryUnits() || !Objects.equals(this.getTimeZone(), other.getTimeZone()) || !this.getIcebergMinPeakSize().equals(other.getIcebergMinPeakSize()) || !this.getIcebergPriceDeltaRange().equals(other.getIcebergPriceDeltaRange()) || !this.getMinQuoteQty().equals(other.getMinQuoteQty()) || this.icebergOrdersSupported != other.icebergOrdersSupported || this.liftOrderProduct != other.liftOrderProduct || this.linkedOrdersSupported != other.linkedOrdersSupported || this.onExchangePrearrangedTrades != other.onExchangePrearrangedTrades || this.otcOnly != other.otcOnly || this.otcSupported != other.otcSupported || this.stopOrdersSuppored != other.stopOrdersSuppored || this.privateAndConfidential != other.privateAndConfidential || this.quoteOrderProduct != other.quoteOrderProduct || this.blockOrderProduct != other.blockOrderProduct || this.aotEnabled != other.aotEnabled || !Objects.equals(this.getRiskSetId(), other.getRiskSetId());
    }

    public boolean isPriceValid(LongDisplayValue price) {
        LongDisplayValue minPrice = this.getPriceMinValue();
        LongDisplayValue maxPrice = this.getPriceMaxValue();
        return price != null && price.compareTo(minPrice) >= 0 && price.compareTo(maxPrice) <= 0 && price.getShift() <= this.getPriceDecimalShift() && price.applyShift(this.getPriceDecimalShift()).getValue() % this.getPriceTickSize().getValue() == 0L;
    }

    public LongDisplayValue getMinQuoteQty() {
        return this.minQuoteQuantity;
    }

    public LongDisplayValue getIcebergMinPeakSize() {
        return this.icebergMinPeakSize;
    }

    public LongDisplayValue getIcebergPriceDeltaRange() {
        return this.icebergDeltaRange;
    }

    public boolean isBaseProduct() {
        return this.isBaseProduct;
    }

    public boolean isLocationsEnabled() {
        return this.isLocationsEnabled;
    }

    public String getBaseProductId() {
        if (this.isBaseProduct()) {
            return (String)this.getId();
        }
        return this.baseProductId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getMasterProductId() {
        return this.masterProductId;
    }

    public String getLinkedProductId() {
        return this.linkedProductId;
    }

    public ProductExecutionRestriction getExecutionRestriction() {
        return this.executionRestriction;
    }

    public boolean supportsOpenCloseIndicator() {
        return false;
    }

    public static class ProductBuilder {
        private String id;
        private Exchange exchange;
        private String displayName;
        private long revisionNumber;
        private String currencyCode;
        private String quantityUnit;
        private int priceDecimalShift;
        private LongDisplayValue priceTickSize;
        private LongDisplayValue priceMinValue;
        private LongDisplayValue priceMaxValue;
        private int quantityDecimalShift;
        private LongDisplayValue quantityLotSize;
        private LongDisplayValue quantityMinValue;
        private LongDisplayValue quantityMaxValue;
        private LongDisplayValue amountMaxValue;
        private double deliveryUnits;
        private String timeZone;
        private String globalMarketId;
        private int priceDecimalShiftForBackend;
        private int quantityDecimalShiftForBackend;
        private ProductType productType;
        private ProductState productState;
        private boolean isBaseProduct;
        private boolean isLocationsEnabled;
        private String baseProductId;
        private String groupName;
        private ProductExecutionRestriction executionRestriction;
        private String masterProductId;
        private String linkedProductId;
        private long icebergMinPeakSize = 1L;
        private long icebergDeltaRange = 1L;
        private long minQuoteQuantity = 1L;
        private boolean icebergOrdersSupported = false;
        private boolean liftOrderProduct = false;
        private boolean linkedOrdersSupported = false;
        private boolean onExchangePrearrangedTrades = false;
        private boolean otcOnly = false;
        private boolean otcSupported = false;
        private boolean stopOrdersSupported = false;
        private boolean privateAndConfidential = false;
        private boolean quoteOrderProduct = false;
        private boolean blockOrderProduct = false;
        private boolean aotEnabled = false;
        private Long riskSetId;

        public ProductBuilder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ProductBuilder withRevisionNumber(long revisionNumber) {
            this.revisionNumber = revisionNumber;
            return this;
        }

        public ProductBuilder withCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public ProductBuilder withQuantityUnit(String quantityUnit) {
            this.quantityUnit = quantityUnit;
            return this;
        }

        public ProductBuilder withPriceDecimalShift(int priceDecimalShift) {
            this.priceDecimalShift = priceDecimalShift;
            return this;
        }

        public ProductBuilder withPriceTickSize(LongDisplayValue priceTickSize) {
            this.priceTickSize = priceTickSize;
            return this;
        }

        public ProductBuilder withPriceMinValue(LongDisplayValue priceMinValue) {
            this.priceMinValue = priceMinValue;
            return this;
        }

        public ProductBuilder withPriceMaxValue(LongDisplayValue priceMaxValue) {
            this.priceMaxValue = priceMaxValue;
            return this;
        }

        public ProductBuilder withQuantityDecimalShift(int quantityDecimalShift) {
            this.quantityDecimalShift = quantityDecimalShift;
            return this;
        }

        public ProductBuilder withQuantityMinValue(LongDisplayValue quantitySmallestTradableUnit) {
            this.quantityMinValue = quantitySmallestTradableUnit;
            return this;
        }

        public ProductBuilder withQuantityLotSize(LongDisplayValue quantityLotSize) {
            this.quantityLotSize = quantityLotSize;
            return this;
        }

        public ProductBuilder withQuantityMaxValue(LongDisplayValue quantityMaxValue) {
            this.quantityMaxValue = quantityMaxValue;
            return this;
        }

        public ProductBuilder withAmountMaxValue(LongDisplayValue amountMaxValue) {
            this.amountMaxValue = amountMaxValue;
            return this;
        }

        public ProductBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public ProductBuilder withExchange(Exchange exchange) {
            this.exchange = exchange;
            return this;
        }

        public ProductBuilder withPriceDecimalShiftForBackend(int priceDecimalShiftForBackend) {
            this.priceDecimalShiftForBackend = priceDecimalShiftForBackend;
            return this;
        }

        public ProductBuilder withQuantityDecimalShiftForBackend(int quantityDecimalShiftForBackend) {
            this.quantityDecimalShiftForBackend = quantityDecimalShiftForBackend;
            return this;
        }

        public ProductBuilder withProductState(ProductState productState) {
            this.productState = productState;
            return this;
        }

        public ProductBuilder withProductType(ProductType productType) {
            this.productType = productType;
            return this;
        }

        public ProductBuilder withDeliveryUnits(double deliveryUnits) {
            this.deliveryUnits = deliveryUnits;
            return this;
        }

        public ProductBuilder withTimezone(String timezone) {
            this.timeZone = timezone;
            return this;
        }

        public ProductBuilder withGlobalMarketId(String globalMarketId) {
            this.globalMarketId = globalMarketId;
            return this;
        }

        public ProductBuilder withIsBaseProduct(boolean isBaseProduct) {
            this.isBaseProduct = isBaseProduct;
            return this;
        }

        public ProductBuilder withIsLocationsEnabled(boolean isLocationsEnabled) {
            this.isLocationsEnabled = isLocationsEnabled;
            return this;
        }

        public ProductBuilder withBaseProductId(String baseProductId) {
            this.baseProductId = baseProductId;
            return this;
        }

        public ProductBuilder withGroupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public ProductBuilder withExecutionRestriction(ProductExecutionRestriction executionRestriction) {
            this.executionRestriction = executionRestriction;
            return this;
        }

        public ProductBuilder withMasterProductId(String masterProductId) {
            this.masterProductId = masterProductId;
            return this;
        }

        public ProductBuilder withLinkedProductId(String linkedProductId) {
            this.linkedProductId = linkedProductId;
            return this;
        }

        public ProductBuilder withIcebergMinPeakSize(long icebergMinPeakSize) {
            this.icebergMinPeakSize = icebergMinPeakSize;
            return this;
        }

        public ProductBuilder withIcebergDeltaRange(long icebergDeltaRange) {
            this.icebergDeltaRange = icebergDeltaRange;
            return this;
        }

        public ProductBuilder withMinQuoteQuantity(long minQuoteQuantity) {
            this.minQuoteQuantity = minQuoteQuantity;
            return this;
        }

        public ProductBuilder withIcebergOrdersSupported(boolean icebergOrdersSupported) {
            this.icebergOrdersSupported = icebergOrdersSupported;
            return this;
        }

        public ProductBuilder withLiftOrderProduct(boolean liftOrderProduct) {
            this.liftOrderProduct = liftOrderProduct;
            return this;
        }

        public ProductBuilder withLinkedOrdersSupported(boolean linkedOrdersSupported) {
            this.linkedOrdersSupported = linkedOrdersSupported;
            return this;
        }

        public ProductBuilder withOnExchangePrearrangedTrades(boolean onExchangePrearrangedTrades) {
            this.onExchangePrearrangedTrades = onExchangePrearrangedTrades;
            return this;
        }

        public ProductBuilder withOtcOnly(boolean otcOnly) {
            this.otcOnly = otcOnly;
            return this;
        }

        public ProductBuilder withOtcSupported(boolean otcSupported) {
            this.otcSupported = otcSupported;
            return this;
        }

        public ProductBuilder withStopOrdersSupported(boolean stopOrdersSupported) {
            this.stopOrdersSupported = stopOrdersSupported;
            return this;
        }

        public ProductBuilder withPrivateAndConfidential(boolean privateAndConfidential) {
            this.privateAndConfidential = privateAndConfidential;
            return this;
        }

        public ProductBuilder withQuoteOrderProduct(boolean quoteOrderProduct) {
            this.quoteOrderProduct = quoteOrderProduct;
            return this;
        }

        public ProductBuilder withBlockOrderProduct(boolean blockOrderProduct) {
            this.blockOrderProduct = blockOrderProduct;
            return this;
        }

        public ProductBuilder withAotEnabled(boolean aotEnabled) {
            this.aotEnabled = aotEnabled;
            return this;
        }

        public ProductBuilder withRiskSetId(Long riskSetId) {
            this.riskSetId = riskSetId;
            return this;
        }

        public Product build() {
            return new Product(this);
        }
    }
}

