/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.LargeDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.RevisionNumbered;
import com.deutscheboerse.comxerv.comtrader.entities.TimeStampProvider;
import com.deutscheboerse.comxerv.comtrader.entities.TradeInfo;
import com.deutscheboerse.comxerv.comtrader.entities.TradeSettlement;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.AggressorIndicatorType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeState;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeType;
import javafx.beans.property.ObjectProperty;
import org.joda.time.DateTime;

public abstract class Trade
extends BroadcastEntity<Long>
implements RevisionNumbered,
Comparable<Trade>,
TimeStampProvider,
LargeDataModelEntity {
    private final TradeInfo tradeInfo;

    protected Trade() {
        this.tradeInfo = new TradeInfo();
    }

    protected Trade(long id) {
        this(id, new TradeInfo());
    }

    protected Trade(long id, TradeInfo tradeInfo) {
        super(id);
        this.tradeInfo = tradeInfo;
    }

    protected Trade(Trade trade) {
        super(trade);
        this.tradeInfo = new TradeInfo(trade.getTradeInfo());
    }

    public TradeInfo getTradeInfo() {
        return this.tradeInfo;
    }

    public abstract Long getTradeId();

    public ObjectProperty<TradeState> tradeStateProperty() {
        return this.tradeInfo.getTradeState();
    }

    public ObjectProperty<DateTime> recallRequestedTimeProperty() {
        return this.tradeInfo.getRecallRequestedTime();
    }

    public ObjectProperty<DateTime> recallGrantedTimeProperty() {
        return this.tradeInfo.getRecallGrantedTime();
    }

    public ObjectProperty<DateTime> recallLatestProcessTimeProperty() {
        return this.tradeInfo.getRecallLatestProcessTime();
    }

    public String getRecallRequestor() {
        return (String)this.tradeInfo.getRecallRequestor().get();
    }

    public void setRecallRequestor(String recallRequestor) {
        this.getTradeInfo().setRecallRequestor(recallRequestor);
    }

    public void setLocation(String location) {
        this.getTradeInfo().setLocation(location);
    }

    public String getLocation() {
        return this.getTradeInfo().getLocation();
    }

    public ObjectProperty<String> recallRequestorProperty() {
        return this.tradeInfo.getRecallRequestor();
    }

    public LongDisplayValue getPrice() {
        return this.tradeInfo.getPrice();
    }

    public void setPrice(LongDisplayValue price) {
        this.tradeInfo.setPrice(price);
    }

    public LongDisplayValue getQuantity() {
        return this.tradeInfo.getQuantity();
    }

    public void setQuantity(LongDisplayValue quantity) {
        this.tradeInfo.setQuantity(quantity);
    }

    public DateTime getRecallGrantedTime() {
        return (DateTime)this.tradeInfo.getRecallGrantedTime().get();
    }

    public void setRecallGrantedTime(DateTime recallGrantedTime) {
        this.tradeInfo.setRecallGrantedTime(recallGrantedTime);
    }

    public DateTime getRecallRequestedTime() {
        return (DateTime)this.tradeInfo.getRecallRequestedTime().get();
    }

    public void setRecallRequestedTime(DateTime recallRequestedTime) {
        this.tradeInfo.setRecallRequestedTime(recallRequestedTime);
    }

    public DateTime getRecallLatestProcessTime() {
        return (DateTime)this.tradeInfo.getRecallLatestProcessTime().get();
    }

    public void setRecallLatestProcessTime(DateTime recallLatestProcessTime) {
        this.tradeInfo.setRecallLatestProcessTime(recallLatestProcessTime);
    }

    @Override
    public long getRevisionNumber() {
        return this.tradeInfo.getRevisionNumber();
    }

    public void setRevisionNumber(long revisionNumber) {
        this.tradeInfo.setRevisionNumber(revisionNumber);
    }

    @Override
    public DateTime getTimeStamp() {
        return this.tradeInfo.getTimeStamp();
    }

    public void setTimeStamp(DateTime timeStamp) {
        this.tradeInfo.setTimeStamp(timeStamp);
    }

    public TradeState getTradeState() {
        return (TradeState)this.tradeInfo.getTradeState().get();
    }

    public void setTradeState(TradeState tradeState) {
        this.tradeInfo.setTradeState(tradeState);
    }

    public TradeType getTradeType() {
        return this.tradeInfo.getTradeType();
    }

    public void setTradeType(TradeType tradeType) {
        this.tradeInfo.setTradeType(tradeType);
    }

    public ContractPhase getContractPhase() {
        return this.tradeInfo.getContractPhase();
    }

    public void setContractPhase(ContractPhase contractPhase) {
        this.tradeInfo.setContractPhase(contractPhase);
    }

    public Contract getContract() {
        return this.tradeInfo.getContract();
    }

    public void setContract(Contract contract) {
        this.tradeInfo.setContract(contract);
    }

    public TradeSettlement getTradeSettlement() {
        return (TradeSettlement)this.tradeInfo.getTradeSettlement().get();
    }

    public ObjectProperty<TradeSettlement> tradeSettlementProperty() {
        return this.tradeInfo.getTradeSettlement();
    }

    public void setTradeSettlement(TradeSettlement tradeSettlement) {
        this.tradeInfo.setTradeSettlement(tradeSettlement);
    }

    public void updateTradeSettlement(TradeSettlement tradeSettlement) {
        TradeSettlement oldSettlement = this.getTradeSettlement();
        if (oldSettlement == null || tradeSettlement.getTradeRevisionNumber() > oldSettlement.getTradeRevisionNumber() || tradeSettlement.getTradeRevisionNumber() == oldSettlement.getTradeRevisionNumber() && tradeSettlement.getStlmntRevisionNumber() > oldSettlement.getStlmntRevisionNumber()) {
            this.setTradeSettlement(tradeSettlement);
        }
    }

    public boolean isDecomposed() {
        return this.tradeInfo.isDecomposed();
    }

    public void setDecomposed(boolean decomposed) {
        this.tradeInfo.setDecomposed(decomposed);
    }

    public Long getParentTradeId() {
        return this.tradeInfo.getParentTradeId();
    }

    public void setParentTradeId(Long parentTradeId) {
        this.tradeInfo.setParentTradeId(parentTradeId);
    }

    public Long getRemoteTradeId() {
        return this.tradeInfo.getRemoteTradeId();
    }

    public void setRemoteTradeId(Long remoteTradeId) {
        this.getTradeInfo().setRemoteTradeId(remoteTradeId);
    }

    public boolean isSelfTrade() {
        return this.tradeInfo.isSelfTrade();
    }

    public void setSelfTrade(boolean selfTrade) {
        this.tradeInfo.setSelfTrade(selfTrade);
    }

    public boolean isRemoved() {
        return this.getTradeState() == TradeState.RECALL_GRANTED || this.getTradeState() == TradeState.CANCELLED;
    }

    protected void mergeCommon(Trade broadcastTrade) {
        this.setRecallRequestedTime(broadcastTrade.getRecallRequestedTime());
        this.setRecallGrantedTime(broadcastTrade.getRecallGrantedTime());
        this.setRecallLatestProcessTime(broadcastTrade.getRecallLatestProcessTime());
        this.setTimeStamp(broadcastTrade.getTimeStamp());
        this.setRevisionNumber(broadcastTrade.getRevisionNumber());
        this.setTradeState(broadcastTrade.getTradeState());
        this.setRecallRequestor(broadcastTrade.getRecallRequestor());
    }

    @Override
    public int compareTo(Trade other) {
        return ((Long)this.getId()).compareTo((Long)other.getId());
    }

    public String toString() {
        if (this.getId() != null) {
            return ((Long)this.getId()).toString();
        }
        return "Trade{contract=" + String.valueOf(this.getContract()) + ", price=" + String.valueOf(this.getPrice()) + ", quantity=" + String.valueOf(this.getQuantity()) + ", tradeSettlement=" + String.valueOf(this.getTradeSettlement()) + "}";
    }

    public boolean isParentOf(Trade childTrade) {
        return this.isDecomposed() && this.getTradeId().equals(childTrade.getParentTradeId());
    }

    public static class OrderInfo {
        private final Long id;
        private final Direction direction;
        private final Integer brokerUserId;
        private final User brokerUser;
        private final String memberCode;
        private final String traderUserCode;
        private final User user;
        private final String deliveryAreaId;
        private final DeliveryArea deliveryArea;
        private final String balancingGroupId;
        private final BalancingGroup balancingGroup;
        private final String account;
        private final String text;
        private final OpenOrClose openOrClose;
        private final String clientOrderId;
        private final AggressorIndicatorType aggressorIndicatorType;

        public OrderInfo(Long id, Direction direction, Integer brokerUserId, User brokerUser, String memberCode, String traderUserCode, User user, String deliveryAreaId, DeliveryArea deliveryArea, String balancingGroupId, BalancingGroup balancingGroup, String account, String text, OpenOrClose openOrClose, String clientOrderId, AggressorIndicatorType aggressorIndicatorType) {
            this.id = id;
            this.direction = direction;
            this.brokerUserId = brokerUserId;
            this.brokerUser = brokerUser;
            this.memberCode = memberCode;
            this.traderUserCode = traderUserCode;
            this.user = user;
            this.deliveryAreaId = deliveryAreaId;
            this.deliveryArea = deliveryArea;
            this.balancingGroupId = balancingGroupId;
            this.balancingGroup = balancingGroup;
            this.account = account;
            this.text = text;
            this.openOrClose = openOrClose;
            this.clientOrderId = clientOrderId;
            this.aggressorIndicatorType = aggressorIndicatorType;
        }

        public Long getId() {
            return this.id;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public Integer getBrokerUserId() {
            return this.brokerUserId;
        }

        public User getBrokerUser() {
            return this.brokerUser;
        }

        public String getText() {
            return this.text;
        }

        public String getMemberCode() {
            return this.memberCode;
        }

        public String getTraderUserCode() {
            return this.traderUserCode;
        }

        public User getUser() {
            return this.user;
        }

        public String getDeliveryAreaId() {
            return this.deliveryAreaId;
        }

        public DeliveryArea getDeliveryArea() {
            return this.deliveryArea;
        }

        public String getAccount() {
            return this.account;
        }

        public String getBalancingGroupId() {
            return this.balancingGroupId;
        }

        public BalancingGroup getBalancingGroup() {
            return this.balancingGroup;
        }

        public String getClientOrderId() {
            return this.clientOrderId;
        }

        public OpenOrClose getOpenOrClose() {
            return this.openOrClose;
        }

        public AggressorIndicatorType getAggressorIndicatorType() {
            return this.aggressorIndicatorType;
        }

        public String toString() {
            return "OrderInfo{id=" + this.id + ", direction=" + String.valueOf(this.direction) + ", brokerUserId=" + this.brokerUserId + ", brokerUser=" + String.valueOf(this.brokerUser) + ", memberCode='" + this.memberCode + "', traderUserCode='" + this.traderUserCode + "', user=" + String.valueOf(this.user) + ", deliveryAreaId='" + this.deliveryAreaId + "', deliveryArea=" + String.valueOf(this.deliveryArea) + ", balancingGroupId='" + this.balancingGroupId + "', balancingGroup=" + String.valueOf(this.balancingGroup) + ", account=" + this.account + ", text='" + this.text + "', openOrClose=" + String.valueOf(this.openOrClose) + ", clientOrderId='" + this.clientOrderId + "', aggressorIndicatorType=" + String.valueOf(this.aggressorIndicatorType) + "}";
        }
    }
}

