/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.session;

import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParameters;
import com.deutscheboerse.comxerv.comtrader.entities.session.DisconnectAction;
import com.deutscheboerse.m7.trading.api.v6.ThrottlingMemberActionType;
import com.deutscheboerse.m7.trading.api.v6.ThrottlingUserActionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.commons.lang3.BooleanUtils;

public class ConnectionParametersWithFallback {
    private final StringProperty username = new SimpleStringProperty();
    private final StringProperty password = new SimpleStringProperty();
    private final StringProperty verificationCode = new SimpleStringProperty();
    private final ObjectProperty<DisconnectAction> disconnectAction;
    private final ObjectProperty<ThrottlingUserActionType> throttlingUserAction;
    private final ObjectProperty<ThrottlingMemberActionType> throttlingMemberAction;
    private final List<ConnectionParameters> params;
    private final BooleanProperty receivePblcOrdrBooksDeltaRprt;
    private final BooleanProperty receivePblcTradeConfRprt;
    private final BooleanProperty useShortOrderbookBatching;
    private final StringProperty orderbookApiVersion;
    private final StringProperty privateDataApiVersion;
    private final Exchange exchange;
    private final String environmentId;
    private final BooleanProperty useLeasedLine;
    private final boolean connectionCheck;
    public static final String CONNECTION_CHECK_KEY = "connection.check";

    public ConnectionParametersWithFallback(ConnectionParameters simpleParams) {
        this(Collections.singletonList(simpleParams));
    }

    public ConnectionParametersWithFallback(List<ConnectionParameters> params) {
        this.params = params;
        this.disconnectAction = new SimpleObjectProperty<DisconnectAction>();
        this.throttlingUserAction = new SimpleObjectProperty<ThrottlingUserActionType>();
        this.throttlingMemberAction = new SimpleObjectProperty<ThrottlingMemberActionType>();
        this.receivePblcOrdrBooksDeltaRprt = new SimpleBooleanProperty(true);
        this.receivePblcTradeConfRprt = new SimpleBooleanProperty(true);
        this.useShortOrderbookBatching = new SimpleBooleanProperty(false);
        this.orderbookApiVersion = new SimpleStringProperty();
        this.privateDataApiVersion = new SimpleStringProperty();
        if (params.isEmpty()) {
            throw new IllegalArgumentException("The properties file must define at least one connection.");
        }
        this.exchange = Exchange.get(this.getPropertyValue(ConnectionParameters::getExchangeId));
        this.environmentId = this.getPropertyValue(ConnectionParameters::getEnvironmentId);
        this.username.addListener((observable2, oldValue, newValue) -> this.setUsernameForAllConnections((String)newValue));
        this.password.addListener((observable2, oldValue, newValue) -> this.setPasswordForAllConnections((String)newValue));
        this.disconnectAction.addListener((observable2, oldValue, newValue) -> this.setDisconnectActionForAllConnections((DisconnectAction)newValue));
        this.disconnectAction.setValue(params.get(0).getDisconnectAction());
        this.throttlingUserAction.addListener((observable2, oldValue, newValue) -> this.setThrottlingUserActionForAllConnections((ThrottlingUserActionType)newValue));
        this.throttlingUserAction.setValue(params.get(0).getThrottlingUserAction());
        this.throttlingMemberAction.addListener((observable2, oldValue, newValue) -> this.setThrottlingMemberActionForAllConnections((ThrottlingMemberActionType)newValue));
        this.throttlingMemberAction.setValue(params.get(0).getThrottlingMemberAction());
        this.useLeasedLine = new SimpleBooleanProperty();
        this.connectionCheck = BooleanUtils.toBoolean(System.getProperty(CONNECTION_CHECK_KEY));
    }

    public void setUseOwnCertificate(boolean useOwnCertificate) {
        this.params.forEach(param -> param.setUseOwnCertificate(useOwnCertificate));
    }

    public void setCertificatePath(String certificatePath) {
        this.params.forEach(param -> param.setCertificatePath(certificatePath));
    }

    public void setCertificatePassword(String certificatePassword) {
        this.params.forEach(param -> param.setCertificatePassword(certificatePassword));
    }

    public static ConnectionParametersWithFallback fromProperties(Properties properties) {
        List<ConnectionParameters> params = ConnectionParametersWithFallback.parse(properties);
        return new ConnectionParametersWithFallback(params);
    }

    public String getName() {
        return this.getPropertyValue(ConnectionParameters::getName);
    }

    public String getEnvironmentName() {
        return this.getPropertyValue(ConnectionParameters::getEnvironmentName);
    }

    public String getChangePasswordHost() {
        return this.getPropertyValue(ConnectionParameters::getChangePasswordHost);
    }

    public boolean isOwnCertificateEnabled() {
        return this.getPropertyValue(ConnectionParameters::getOwnCertificateEnabled);
    }

    public boolean isUseOwnCertificate() {
        return this.getPropertyValue(ConnectionParameters::getUseOwnCertificate);
    }

    public boolean isCertificatePerUser() {
        return this.getPropertyValue(ConnectionParameters::getCertificatePerUser);
    }

    public String getCertificatePath() {
        return this.getPropertyValue(ConnectionParameters::getCertificatePath);
    }

    public String getCertificatePassword() {
        return this.getPropertyValue(ConnectionParameters::getCertificatePassword);
    }

    private <T> T getPropertyValue(Function<ConnectionParameters, T> property) {
        if (this.params.stream().map(property).distinct().count() != 1L) {
            throw new IllegalArgumentException("All connection parameters are supposed to refer to the same exchange/environment.");
        }
        return property.apply(this.params.get(0));
    }

    private void setUsernameForAllConnections(String usernameForAllConnections) {
        this.params.forEach(params -> params.setRabbitUser(usernameForAllConnections));
    }

    private void setPasswordForAllConnections(String passwordForAllConnections) {
        this.params.forEach(p -> p.setRabbitPassword(passwordForAllConnections));
    }

    private void setDisconnectActionForAllConnections(DisconnectAction disconnectActionForAllConnections) {
        this.params.forEach(p -> p.setDisconnectAction(disconnectActionForAllConnections));
    }

    private void setThrottlingUserActionForAllConnections(ThrottlingUserActionType throttlingUserAction) {
        this.params.forEach(p -> p.setThrottlingUserAction(throttlingUserAction));
    }

    private void setThrottlingMemberActionForAllConnections(ThrottlingMemberActionType throttlingMemberAction) {
        this.params.forEach(p -> p.setThrottlingMemberAction(throttlingMemberAction));
    }

    private static List<ConnectionParameters> parse(Properties properties) {
        ArrayList<ConnectionParameters> paramsList = new ArrayList<ConnectionParameters>();
        int i = 0;
        while (true) {
            ConnectionParameters params = new ConnectionParameters();
            String prefix = "connectionParameters" + i + ".";
            if (properties.get(prefix + "name") == null) break;
            params.setName(properties.getProperty(prefix + "name"));
            params.setLeasedLine(Boolean.parseBoolean(properties.getProperty(prefix + "leasedLine", Boolean.FALSE.toString())));
            params.setEnvironmentId(properties.getProperty(prefix + "environmentId"));
            params.setEnvironmentName(properties.getProperty(prefix + "environmentName"));
            params.setExchangeId(properties.getProperty(prefix + "exchangeId"));
            params.setRabbitHost(properties.getProperty(prefix + "rabbitHost"));
            params.setRabbitUser(properties.getProperty(prefix + "rabbitUser"));
            params.setRabbitPassword(properties.getProperty(prefix + "rabbitPassword"));
            params.setRabbitVHost(properties.getProperty(prefix + "rabbitVHost"));
            params.setRabbitPort(Integer.valueOf(properties.getProperty(prefix + "rabbitPort")));
            params.setOwnCertificateEnabled(Boolean.parseBoolean(properties.getProperty(prefix + "ownCertificateEnabled", Boolean.FALSE.toString())));
            params.setUseOwnCertificate(Boolean.valueOf(properties.getProperty(prefix + "useOwnCertificate", Boolean.FALSE.toString())));
            params.setCertificatePerUser(Boolean.parseBoolean(properties.getProperty(prefix + "certificatePerUser", Boolean.FALSE.toString())));
            params.setCertificatePath(properties.getProperty(prefix + "certificatePath"));
            params.setCertificatePassword(properties.getProperty(prefix + "certificatePassword"));
            params.setDisconnectAction(DisconnectAction.valueOf(properties.getProperty(prefix + "disconnectAction", DisconnectAction.NO.name())));
            params.setUseNonSslConnection(Boolean.valueOf(properties.getProperty(prefix + "useNonSslConnection", Boolean.FALSE.toString())));
            params.setServerCertFilePath(properties.getProperty(prefix + "serverCertFilePath"));
            params.setChangePasswordHost(properties.getProperty(prefix + "changePasswordHost"));
            paramsList.add(params);
            ++i;
        }
        return paramsList;
    }

    public List<ConnectionParameters> getConnectionParameters() {
        return Collections.unmodifiableList(this.params);
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getUsername() {
        return (String)this.username.get();
    }

    public StringProperty usernameProperty() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username.set(username);
    }

    public String getPassword() {
        return (String)this.password.get();
    }

    public StringProperty passwordProperty() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password.set(password);
    }

    public String getVerificationCode() {
        return (String)this.verificationCode.get();
    }

    public void setVerificationCode(String password) {
        this.verificationCode.set(password);
    }

    public DisconnectAction getDisconnectAction() {
        return (DisconnectAction)this.disconnectAction.get();
    }

    public void setDisconnectAction(DisconnectAction disconnectAction) {
        this.disconnectAction.set(disconnectAction);
    }

    public ThrottlingUserActionType getThrottlingUserAction() {
        return (ThrottlingUserActionType)this.throttlingUserAction.get();
    }

    public void setThrottlingUserAction(ThrottlingUserActionType throttlingUserAction) {
        this.throttlingUserAction.set(throttlingUserAction);
    }

    public ThrottlingMemberActionType getThrottlingMemberAction() {
        return (ThrottlingMemberActionType)this.throttlingMemberAction.get();
    }

    public void setThrottlingMemberAction(ThrottlingMemberActionType throttlingMemberAction) {
        this.throttlingMemberAction.set(throttlingMemberAction);
    }

    public boolean getUseLeasedLine() {
        return this.useLeasedLine.get();
    }

    public BooleanProperty useLeasedLineProperty() {
        return this.useLeasedLine;
    }

    public void setUseLeasedLine(boolean useLeasedLine) {
        this.useLeasedLine.set(useLeasedLine);
    }

    public boolean isConnectionCheck() {
        return this.connectionCheck;
    }

    public void setReceivePblcOrdrBooksDeltaRprt(boolean value) {
        this.receivePblcOrdrBooksDeltaRprt.set(value);
    }

    public boolean isReceivePblcOrdrBooksDeltaRprt() {
        return this.receivePblcOrdrBooksDeltaRprt.get();
    }

    public void setReceivePblcTradeConfRprt(boolean value) {
        this.receivePblcTradeConfRprt.set(value);
    }

    public boolean isReceivePblcTradeConfRprt() {
        return this.receivePblcTradeConfRprt.get();
    }

    public boolean isUseShortOrderbookBatching() {
        return this.useShortOrderbookBatching.get();
    }

    public void setUseLongOrderbookBatching(boolean useLongOrderbookBatching) {
        this.useShortOrderbookBatching.set(useLongOrderbookBatching);
    }

    public String getOrderbookApiVersion() {
        return (String)this.orderbookApiVersion.get();
    }

    public void setOrderbookApiVersion(String orderbookApiVersion) {
        this.orderbookApiVersion.set(orderbookApiVersion);
    }

    public String getPrivateDataApiVersion() {
        return (String)this.privateDataApiVersion.get();
    }

    public void setPrivateDataApiVersion(String privateDataApiVersion) {
        this.privateDataApiVersion.set(privateDataApiVersion);
    }
}

