/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Map;
import javafx.fxml.FXMLLoader;

public class CachingClassLoader
extends ClassLoader {
    private final Map<String, Class<?>> classes = Maps.newHashMap();
    private final ClassLoader parent;
    private static CachingClassLoader classLoader;

    public static synchronized CachingClassLoader getClassLoader() {
        if (classLoader == null) {
            AccessController.doPrivileged(() -> {
                classLoader = new CachingClassLoader(FXMLLoader.getDefaultClassLoader());
                return null;
            });
        }
        return classLoader;
    }

    private CachingClassLoader(ClassLoader parent) {
        this.parent = parent;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> c = this.findClass(name);
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        if (this.classes.containsKey(className)) {
            Class<?> result = this.classes.get(className);
            return result;
        }
        try {
            Class<?> result = this.parent.loadClass(className);
            this.classes.put(className, result);
            return result;
        }
        catch (ClassNotFoundException ignore) {
            this.classes.put(className, null);
            return null;
        }
    }

    @Override
    public URL getResource(String name) {
        return this.parent.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.parent.getResources(name);
    }

    public String toString() {
        return this.parent.toString();
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        this.parent.setDefaultAssertionStatus(enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.parent.setPackageAssertionStatus(packageName, enabled);
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        this.parent.setClassAssertionStatus(className, enabled);
    }

    @Override
    public void clearAssertionStatus() {
        this.parent.clearAssertionStatus();
    }
}

