/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.msgrecorder.ShowAmqpMessageBodyCellCustomizer;
import com.deutscheboerse.comxerv.comtrader.jfx.service.WindowService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.amqp.MessageSender;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpNames;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.trading.api.v6.ChgPwdReq;
import com.deutscheboerse.m7.trading.api.v6.CreateUsersReq;
import com.deutscheboerse.m7.trading.api.v6.ModifyUsersReq;
import com.google.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.apache.commons.lang3.StringUtils;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GuiMessageSender
extends FXMLBorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(GuiMessageSender.class);
    private static final Pattern PWD_ATTR = Pattern.compile("\\b(.*?(pwd|password))\\s*=\\s*\"[^\"]+\"", 2);
    private static final String[] REQUESTS_WITH_PASSWORD_NAMES = new String[]{ChgPwdReq.class.getSimpleName(), CreateUsersReq.class.getSimpleName(), ModifyUsersReq.class.getSimpleName()};
    private final Stage stage;
    private final MessageSender messageSender;
    private final AmqpNames amqpNames;
    @FXML
    private CodeArea xmlMessage;
    @FXML
    private ChoiceBox<String> queueChoice;
    @FXML
    private CheckBox compressCheckBox;
    @FXML
    private TextField eventIndexField;
    private final boolean withSendMessageMultiple;

    @Inject
    public GuiMessageSender(ApplicationContext applicationContext) {
        super(applicationContext);
        Session session = applicationContext.getService(BackendConnectionGateway.class).getSession();
        this.messageSender = applicationContext.getService(MessageSender.class);
        this.amqpNames = applicationContext.getService(AmqpNames.class, session.getExchange());
        this.stage = new Stage(StageStyle.DECORATED);
        this.stage.setScene(new Scene(this, 1280.0, 800.0));
        this.stage.setTitle(Util.getLabel("commons_sendMessageWindowTitle", session.getConnectionParameters().getRabbitUser()));
        applicationContext.getService(WindowService.class).decorateWindow(this.stage);
        this.withSendMessageMultiple = applicationContext.getService(ApplicationConfigurationService.class).getBooleanApplicationProperty("withSendMessageMultiple");
        this.loadFxml();
    }

    public void initialize() {
        this.xmlMessage.setParagraphGraphicFactory(LineNumberFactory.get(this.xmlMessage));
        this.xmlMessage.textProperty().addListener((obs, oldText, newText) -> this.xmlMessage.setStyleSpans(0, ShowAmqpMessageBodyCellCustomizer.computeHighlighting(newText)));
        this.queueChoice.getItems().addAll((String[])new String[]{this.amqpNames.getInquiryRoutingKey(), this.amqpNames.getThrottlingInquiryRoutingKey(), this.amqpNames.getManagementRoutingKey()});
    }

    public void showDialog() {
        this.reset();
        this.stage.show();
        this.stage.toFront();
    }

    @FXML
    public void send() {
        for (String xmlMessageText : this.getXmlMessages()) {
            if (LOG.isInfoEnabled()) {
                if (StringUtils.containsAny((CharSequence)xmlMessageText.substring(0, Math.min(32, xmlMessageText.length())), REQUESTS_WITH_PASSWORD_NAMES)) {
                    LOG.info("Sending plain xml message:\n{}", (Object)PWD_ATTR.matcher(xmlMessageText).replaceAll("$1=\"*****\""));
                } else {
                    LOG.info("Sending plain xml message:\n{}", (Object)xmlMessageText);
                }
            }
            this.messageSender.send(this.queueChoice.getValue(), xmlMessageText, this.compressCheckBox.isSelected(), this.parseUserInputtedEventIndex());
        }
        this.cancel();
    }

    private List<String> getXmlMessages() {
        if (this.withSendMessageMultiple) {
            return Arrays.stream(this.xmlMessage.getText().split("(?m)^\\s*$")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        }
        return List.of(this.xmlMessage.getText());
    }

    @FXML
    public void cancel() {
        this.stage.close();
    }

    private void reset() {
        this.xmlMessage.replaceText("");
        this.queueChoice.setValue(this.amqpNames.getInquiryRoutingKey());
        this.compressCheckBox.setSelected(false);
        this.eventIndexField.setText("");
    }

    private Long parseUserInputtedEventIndex() {
        String idxText;
        String string = idxText = this.eventIndexField.getText() == null ? "" : this.eventIndexField.getText().trim();
        if (idxText.isEmpty()) {
            return null;
        }
        try {
            return Long.valueOf(idxText);
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid eventIndex value '{}', ignoring and sending event index from last response", (Object)idxText);
            return null;
        }
    }
}

