/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookValueWrapper;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractOrderbookPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.SimpleLongDisplayValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.market.AbstractMarketOrderWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ContractRestriction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OrderbookRemovalCallback;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OwnMarketPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.TabularOrderbookPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CustomTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableLayoutDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TableUpdateManager;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMarketMakerPanel<T extends AbstractMarketOrderWrapper>
extends AbstractOrderbookPanel<T, DeliveryArea>
implements StorableComponent<OwnMarketPanelState<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMarketMakerPanel.class);
    private final DataModelListener<Orderbook> orderbookDataModelListener;
    private final TableUpdateManager tableUpdateManager;
    @FXML
    protected CustomTableView<T> marketTableView;
    @FXML
    protected Button stepUpButton;
    @FXML
    protected Button stepDownButton;
    @FXML
    protected Button narrowButton;
    @FXML
    protected Button widenButton;
    protected List<BooleanProperty> submittingProperties = new LinkedList<BooleanProperty>();
    protected final BooleanProperty anyOfSelectedRowsSubmitting = new SimpleBooleanProperty(false);
    private final BooleanProperty hasValidProductStepSizes = new SimpleBooleanProperty(false);
    private ChangeListener<Boolean> submittingListener = (observableValue, aBoolean, aBoolean2) -> FxUtil.runLater(() -> {
        for (BooleanProperty submittingProperty : this.submittingProperties) {
            if (!submittingProperty.getValue().booleanValue()) continue;
            this.anyOfSelectedRowsSubmitting.setValue(true);
            return;
        }
        this.anyOfSelectedRowsSubmitting.setValue(false);
    });

    public AbstractMarketMakerPanel(ApplicationContext applicationContext, Predicate<Contract> contractFilter, Predicate<Product> productFilter) {
        super(applicationContext, contractFilter, productFilter);
        this.tableUpdateManager = this.getAppContext().getService(TableUpdateManager.class);
        this.orderbookDataModelListener = new AbstractDataModelListener<Orderbook>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(Orderbook object) {
                LOG.trace("Orderbook notifyAdd {}", (Object)object);
                AbstractMarketMakerPanel.this.tableUpdateManager.submitSortRequest(AbstractMarketMakerPanel.this.marketTableView);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdate(Orderbook object) {
                LOG.trace("Orderbook notifyUpdate {}", (Object)object);
                AbstractMarketMakerPanel.this.tableUpdateManager.submitSortRequest(AbstractMarketMakerPanel.this.marketTableView);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        };
        this.loadFxml();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.filteredOrderbooks.addListener(change -> this.tableUpdateManager.submitSortRequest(this.marketTableView));
        SortedList orderbooks = new SortedList(this.filteredOrderbooks);
        this.marketTableView.setItems(orderbooks);
        orderbooks.comparatorProperty().bind(this.marketTableView.comparatorProperty());
        this.marketTableView.getSelectionModel().getSelectedItems().addListener(change -> {
            for (BooleanProperty submittingProperty : this.submittingProperties) {
                submittingProperty.removeListener(this.submittingListener);
            }
            this.submittingProperties.clear();
            for (AbstractMarketOrderWrapper wrapper : this.marketTableView.getSelectionModel().getSelectedItems()) {
                this.submittingProperties.add(wrapper.submittingProperty());
                wrapper.submittingProperty().addListener(this.submittingListener);
            }
        });
        this.marketTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.marketTableView.getSelectionModel().getSelectedItems().addListener(change -> this.recalculateValidProductStepSizes());
        this.getContractTree().hasValidProductStepSizesProperty().addListener(observable2 -> this.recalculateValidProductStepSizes());
        this.getAreaChoiceBox().disableProperty().bind(this.anyOfSelectedRowsSubmitting);
        this.getAppContext().getSmallDataModel(Orderbook.class).registerListener(new WeakDataModelListener<Orderbook>(this.orderbookDataModelListener));
    }

    private void recalculateValidProductStepSizes() {
        if (!this.getContractTree().hasValidProductStepSizesProperty().get() && this.marketTableView.getSelectionModel().getSelectedItem() != null) {
            this.hasValidProductStepSizes.setValue(Boolean.TRUE);
            return;
        }
        for (Map.Entry<Product, SimpleLongDisplayValueField> entryToSearch : this.getContractTree().getProductStepSizes().entrySet()) {
            if (entryToSearch.getValue().isValid()) continue;
            for (AbstractMarketOrderWrapper selectedItem : this.marketTableView.getSelectionModel().getSelectedItems()) {
                Product product = selectedItem.getOrderbook().getContract().getProduct();
                if (!entryToSearch.getKey().equals(product)) continue;
                this.hasValidProductStepSizes.setValue(Boolean.FALSE);
                return;
            }
        }
        this.hasValidProductStepSizes.setValue(Boolean.TRUE);
    }

    protected BooleanBinding getButtonDisableBinding() {
        return this.hasValidProductStepSizes.not().or(Bindings.isEmpty(this.marketTableView.getSelectionModel().getSelectedItems())).or(this.anyOfSelectedRowsSubmitting);
    }

    @Override
    public void addContracts(List<Contract> contracts, ContractRestriction restriction, ContractAdditionOrigin origin) {
        DeliveryArea selectedArea = (DeliveryArea)this.deliveryAreaChoiceBox.getValue();
        ArrayList<Orderbook> toAdd = Lists.newArrayList();
        User user = this.userService.getCurrentUser();
        for (Contract contract : this.filterContractsToAdd(contracts)) {
            Optional<Object> orderbook2add = Optional.empty();
            if (selectedArea != null) {
                orderbook2add = this.orderbookQueries.findByContractIdAndDeliveryAreaId((Long)contract.getId(), (String)selectedArea.getId());
            }
            DeliveryArea defaultDeliveryArea = this.orderPreferencesService.getDefaultDeliveryArea();
            if (!orderbook2add.isPresent() && defaultDeliveryArea != null && defaultDeliveryArea.getId() != null) {
                orderbook2add = this.orderbookQueries.findByContractIdAndDeliveryAreaId((Long)contract.getId(), (String)defaultDeliveryArea.getId());
            }
            if (!orderbook2add.isPresent()) {
                orderbook2add = this.orderbookQueries.findByContract(contract).stream().filter(o -> o.getContract().getCompoundStatus().getDeliveryAreaStatusOrInactive(o.getDeliveryArea()).isActive() && this.assignmentService.isDeliveryAreaAssignedToUser(user, o.getDeliveryArea())).findFirst();
            }
            if (orderbook2add.isPresent()) {
                Orderbook orderbook = (Orderbook)orderbook2add.get();
                toAdd.add(orderbook);
                LOG.debug("Orderbook added: {}", (Object)orderbook);
                continue;
            }
            LOG.debug("No suitable active orderbook for {} found.", (Object)contract);
        }
        this.addOrderbooks(toAdd, restriction, origin);
    }

    @Override
    protected void restoreAddOrderbook(Orderbook orderbook) {
        this.addContracts(Lists.newArrayList(orderbook.getContract()), ContractRestriction.UNRESTRAINED, ContractAdditionOrigin.MANUAL);
    }

    @Override
    public abstract T getOrderbookItem(Orderbook var1, OrderbookRemovalCallback var2, ContractAdditionOrigin var3);

    @FXML
    public void stepUp() {
        for (AbstractMarketOrderWrapper bestOwnOrderWrapper : this.marketTableView.getSelectionModel().getSelectedItems()) {
            bestOwnOrderWrapper.applyStep(this.getProductStepSizeValue(bestOwnOrderWrapper), Direction.SELL, Direction.BUY);
        }
    }

    @FXML
    public void stepDown() {
        for (AbstractMarketOrderWrapper bestOwnOrderWrapper : this.marketTableView.getSelectionModel().getSelectedItems()) {
            bestOwnOrderWrapper.applyStep(this.getProductStepSizeValue(bestOwnOrderWrapper).invert(), Direction.BUY, Direction.SELL);
        }
    }

    @FXML
    public void narrow() {
        for (AbstractMarketOrderWrapper bestOwnOrderWrapper : this.marketTableView.getSelectionModel().getSelectedItems()) {
            bestOwnOrderWrapper.narrow(this.getProductStepSizeValue(bestOwnOrderWrapper));
        }
    }

    @FXML
    public void widen() {
        for (AbstractMarketOrderWrapper bestOwnOrderWrapper : this.marketTableView.getSelectionModel().getSelectedItems()) {
            bestOwnOrderWrapper.widen(this.getProductStepSizeValue(bestOwnOrderWrapper));
        }
    }

    @FXML
    public void fillUp() {
        for (AbstractMarketOrderWrapper bestOwnOrderWrapper : this.marketTableView.getSelectionModel().getSelectedItems()) {
            bestOwnOrderWrapper.fillUp(Direction.BUY);
            bestOwnOrderWrapper.fillUp(Direction.SELL);
        }
    }

    @Override
    public void restoreComponentState(OwnMarketPanelState<T> componentState) {
        super.restoreComponentState(componentState.getTabularOrderbookPanelState().getOrderbookPanelState());
        for (Map.Entry<String, LongDisplayValue> entry : componentState.getProductIdStepSize().entrySet()) {
            for (Map.Entry<Product, SimpleLongDisplayValueField> entryToSearch : this.getContractTree().getProductStepSizes().entrySet()) {
                if (!((String)entryToSearch.getKey().getId()).equals(entry.getKey())) continue;
                entryToSearch.getValue().setValue(entry.getValue());
            }
        }
        componentState.getTabularOrderbookPanelState().getOrderbookTableDescriptor().applyToTable(this.marketTableView);
    }

    @Override
    public OwnMarketPanelState<T> getComponentState() {
        StorableTableLayoutDescriptor<T> storableTableLayoutDescriptor = StorableTableLayoutDescriptor.fromTable(this.marketTableView);
        TabularOrderbookPanelState<T> tabularOrderbookPanelState = new TabularOrderbookPanelState<T>(this.getBasicState(), storableTableLayoutDescriptor, false);
        return new OwnMarketPanelState<T>(tabularOrderbookPanelState, this.getTreeProductStepSizes());
    }

    public TableView<T> getMarketTableView() {
        return this.marketTableView;
    }

    private Map<String, LongDisplayValue> getTreeProductStepSizes() {
        return this.getContractTree().getProductStepSizes().entrySet().stream().collect(Collectors.toMap(entry -> (String)((Product)entry.getKey()).getId(), entry -> ((SimpleLongDisplayValueField)entry.getValue()).getValue()));
    }

    private LongDisplayValue getProductStepSizeValue(T bestOwnOrderWrapper) {
        return this.getContractTree().getProductStepSizes().get(((OrderbookValueWrapper)bestOwnOrderWrapper).getOrderbook().getContract().getProduct()).getValue();
    }
}

