/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ExportableTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ImportExportService;
import com.deutscheboerse.ui.jfx.util.event.KeyEventUtil;
import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Cursor;
import javafx.scene.control.Button;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Window;
import org.joda.time.DateTime;

public abstract class ExportableAbstractPanel<S>
extends AbstractPanel {
    private final ImportExportService importExportService;

    public ExportableAbstractPanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public ExportableAbstractPanel(ApplicationContext appContext) {
        super(appContext);
        this.importExportService = appContext.getService(ImportExportService.class);
        this.addEventFilter(KeyEvent.KEY_PRESSED, (? super T keyEvent) -> {
            if (KeyEventUtil.isCtrlKeyCode(KeyCode.C, keyEvent)) {
                this.exportSelectionClipboard(new ActionEvent());
                keyEvent.consume();
            } else if (KeyEventUtil.isCtrlAltKeyCode(KeyCode.C, keyEvent)) {
                this.exportClipboard(new ActionEvent());
                keyEvent.consume();
            } else if (KeyEventUtil.isCtrlKeyCode(KeyCode.E, keyEvent)) {
                this.exportSelectionCSV(new ActionEvent());
                keyEvent.consume();
            } else if (KeyEventUtil.isCtrlAltKeyCode(KeyCode.E, keyEvent)) {
                this.exportCSV(new ActionEvent());
                keyEvent.consume();
            }
        });
    }

    @FXML
    public void exportCSV(ActionEvent actionEvent) {
        this.getSourceButton(actionEvent).ifPresent(b -> b.setDisable(true));
        this.importExportService.exportToCsvFile(this.getAllExportableTableView(), this.getWindow(), this.getFileName().replace(" ", "_")).thenRun(() -> this.getSourceButton(actionEvent).ifPresent(b -> b.setDisable(false)));
    }

    @FXML
    public void exportSelectionCSV(ActionEvent actionEvent) {
        this.getSourceButton(actionEvent).ifPresent(b -> b.setDisable(true));
        this.importExportService.exportToCsvFile(this.getSelectedExportableTableView(), this.getWindow(), this.getFileName()).thenRun(() -> this.getSourceButton(actionEvent).ifPresent(b -> b.setDisable(false)));
    }

    @FXML
    public void exportClipboard(ActionEvent actionEvent) {
        this.exportToClipboard(actionEvent, this.getAllExportableTableView());
    }

    @FXML
    public void exportSelectionClipboard(ActionEvent actionEvent) {
        this.exportToClipboard(actionEvent, this.getSelectedExportableTableView());
    }

    private void exportToClipboard(ActionEvent actionEvent, ExportableTableView<S> exportableTableView) {
        this.getScene().setCursor(Cursor.WAIT);
        this.getSourceButton(actionEvent).ifPresent(b -> b.setDisable(true));
        this.importExportService.exportToClipboard(exportableTableView).thenRun(() -> {
            this.getScene().setCursor(Cursor.DEFAULT);
            this.getSourceButton(actionEvent).ifPresent(b -> b.setDisable(false));
        });
    }

    protected ExportableTableView<S> getAllExportableTableView() {
        return new ExportableTableView<S>(this.getTableView(), ExportableTableView.Mode.ALL);
    }

    protected ExportableTableView<S> getSelectedExportableTableView() {
        return new ExportableTableView<S>(this.getTableView(), ExportableTableView.Mode.SELECTED);
    }

    protected abstract TableView<S> getTableView();

    private String getFileName() {
        DateTime now = DateTime.now();
        return now.toString("yyyy-MM-dd") + "-" + this.getComponentName();
    }

    private Window getWindow() {
        return this.getScene().getWindow();
    }

    private Optional<Button> getSourceButton(ActionEvent actionEvent) {
        return Optional.ofNullable(actionEvent.getSource() instanceof Button ? (Button)actionEvent.getSource() : null);
    }
}

