/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.scene.control.Tooltip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TooltipFactory {
    public static final int MAX_SIZE = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(TooltipFactory.class);
    private static Map<String, Tooltip> tooltipMap = new ConcurrentHashMap<String, Tooltip>();

    private TooltipFactory() {
    }

    public static Tooltip getToolTip(String tooltipText) {
        Tooltip tooltip = tooltipMap.get(tooltipText);
        if (tooltip == null) {
            tooltip = new Tooltip(tooltipText);
            if (tooltipMap.size() >= 1000) {
                LOG.error("TooltipFactory maximum size reached. Probably wrong usage. The tooltip: {}", (Object)tooltipText);
            } else {
                tooltipMap.put(tooltipText, tooltip);
            }
        }
        return tooltip;
    }

    public static void clear() {
        tooltipMap.clear();
    }
}

