/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.entity.EntityFilters;
import com.deutscheboerse.comxerv.comtrader.domain.query.BalancingGroupQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.EntityAutoCompleteField;
import com.deutscheboerse.ui.jfx.util.control.AutoCompleteTextField;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public class BalancingGroupField
extends EntityAutoCompleteField<BalancingGroup> {
    private final BalancingGroupQueries balancingGroupQueries;
    private final ObjectProperty<User> trader;
    private final ObjectProperty<Product> product;

    public BalancingGroupField() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public BalancingGroupField(ApplicationContext appContext) {
        super(appContext);
        this.balancingGroupQueries = appContext.getService(BalancingGroupQueries.class);
        this.trader = new SimpleObjectProperty<User>();
        this.product = new SimpleObjectProperty<Product>();
        this.setToStringConverter(BalancingGroup::getDisplayName);
        this.setValid(false);
    }

    @Override
    public Stream<BalancingGroup> getSuggestedEntities(String currentText) {
        if (this.trader.get() != null && this.product.get() != null) {
            return this.getDataQuery().addFilter(EntityFilters.containsIgnoreCase(this.getToStringConverter(), Optional.ofNullable(currentText).orElse(""))).getAll().sorted(new AutoCompleteTextField.ToStringConverterComparator(this.getToStringConverter()));
        }
        return Stream.empty();
    }

    @Override
    public Optional<BalancingGroup> getEntity(String currentText) {
        if (this.trader.get() != null && this.product.get() != null && currentText != null && !currentText.isEmpty()) {
            Optional<BalancingGroup> balancingGroupOptional = this.getDataQuery().addFilter(EntityFilters.propertyEquals(this.getToStringConverter(), currentText)).getFirst();
            this.setValid(balancingGroupOptional.isPresent());
            return balancingGroupOptional;
        }
        this.setValid(false);
        return Optional.empty();
    }

    private DataQuery<BalancingGroup> getDataQuery() {
        return this.balancingGroupQueries.findByIds(((User)this.trader.get()).getBalancingGroupIds()).addFilter(bg -> this.product.get() != null && bg.getProductIds().contains(((Product)this.product.get()).getId())).addFilter(BalancingGroup::isOtcTrading);
    }

    public User getTrader() {
        return (User)this.trader.get();
    }

    public ObjectProperty<User> traderProperty() {
        return this.trader;
    }

    public Product getProduct() {
        return (Product)this.product.get();
    }

    public ObjectProperty<Product> productProperty() {
        return this.product;
    }
}

