/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BespokeContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.PutOrCall;
import com.deutscheboerse.comxerv.comtrader.jfx.components.BespokeTradesPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke.BespokeValidator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ContractShuttleSelectionField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DefaultButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.OptProductField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.SimpleLongDisplayValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.service.NotificationService;
import com.deutscheboerse.comxerv.comtrader.jfx.util.UtilityStages;
import com.deutscheboerse.comxerv.comtrader.service.trade.BespokeService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class BespokeContractEditorPane
extends FXMLBorderPane {
    private static final int NAMEMAXLENGTH = 64;
    private final BespokeService bespokeService;
    private final SmallFastDataModel<Long, Contract> contractDataModel;
    private final ContractQueries contractQueries;
    private final BespokeValidator bespokeValidator;
    private Stage stage;
    private final BespokeTradesPanel parent;
    @FXML
    private TextField nameTextField;
    @FXML
    private OptProductField underlyingProductChoiceBox;
    @FXML
    private ContractShuttleSelectionField contractsShuttleSelectionField;
    @FXML
    private CheckBox optionCheckBoxField;
    @FXML
    private SimpleLongDisplayValueField strikePriceField;
    @FXML
    private ChoiceBox<PutOrCall> contractTypeField;
    @FXML
    private DefaultButton submitButton;
    @FXML
    private Button cancelButton;
    private final SimpleBooleanProperty isInvalid;
    private final SimpleBooleanProperty isOneContractSelected;
    private DependentBinding<LongDisplayValue> minimumPriceBinding;
    private DependentBinding<LongDisplayValue> maximumPriceBinding;

    public BespokeContractEditorPane(ApplicationContext applicationContext, BespokeTradesPanel parent) {
        super(applicationContext);
        this.stage = applicationContext.getService(UtilityStages.class).withKey(BespokeContractEditorPane.class.getName()).get();
        this.stage.setTitle(Util.getLabel("bespokeTradesPanel_createContract_header_label"));
        this.stage.setAlwaysOnTop(true);
        this.bespokeService = applicationContext.getService(BespokeService.class);
        this.contractDataModel = applicationContext.getSmallDataModel(Contract.class);
        this.contractQueries = applicationContext.getService(ContractQueries.class);
        NotificationService.Notifier notifier = applicationContext.getService(NotificationService.class).createNotifier(this, Pos.BOTTOM_CENTER);
        this.bespokeValidator = new BespokeValidator(notifier, this.contractQueries);
        this.isInvalid = new SimpleBooleanProperty();
        this.isOneContractSelected = new SimpleBooleanProperty();
        this.parent = parent;
        this.loadFxml();
    }

    public void initialize() {
        this.underlyingProductInit();
        this.contractShuttleInit();
        this.contractTypeFieldInit();
        this.priceInit();
        this.optionsAndFlagsInit();
        this.submitButton.disableProperty().bind(this.isInvalid);
    }

    private void optionsAndFlagsInit() {
        this.optionCheckBoxField.setDisable(true);
        this.isOneContractSelected.addListener((ChangeListener<? super Boolean>)((ChangeListener<Boolean>)(observable2, oldValue, newValue) -> this.optionCheckBoxField.setSelected((boolean)newValue)));
        this.optionCheckBoxField.selectedProperty().addListener((observable2, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.strikePriceField.setValue(null);
                this.contractTypeField.getSelectionModel().selectFirst();
            }
        });
        this.isInvalid.bind(this.nameTextField.textProperty().isEmpty().or(this.contractsShuttleSelectionField.emptySelectedItemsProperty()).or(this.optionCheckBoxField.selectedProperty().and(this.strikePriceField.validProperty().not().or(this.contractTypeField.valueProperty().isNull()))));
        this.isOneContractSelected.bind(Bindings.size(this.contractsShuttleSelectionField.getSelectedItems().getItems()).isEqualTo(1));
    }

    private void priceInit() {
        this.minimumPriceBinding = new DependentBinding<LongDisplayValue>(new Observable[]{this.contractsShuttleSelectionField.productProperty()}){

            @Override
            protected LongDisplayValue computeValue() {
                if (BespokeContractEditorPane.this.contractsShuttleSelectionField.productProperty().getValue() != null) {
                    return ((Product)BespokeContractEditorPane.this.contractsShuttleSelectionField.productProperty().getValue()).getPriceMinValue();
                }
                return new LongDisplayValue(1L, 0);
            }
        };
        this.maximumPriceBinding = new DependentBinding<LongDisplayValue>(new Observable[]{this.contractsShuttleSelectionField.productProperty()}){

            @Override
            protected LongDisplayValue computeValue() {
                if (BespokeContractEditorPane.this.contractsShuttleSelectionField.productProperty().getValue() != null) {
                    return ((Product)BespokeContractEditorPane.this.contractsShuttleSelectionField.productProperty().getValue()).getPriceMaxValue();
                }
                return new LongDisplayValue(Integer.MAX_VALUE, 0);
            }
        };
        this.strikePriceField.minimumProperty().bind(this.minimumPriceBinding);
        this.strikePriceField.maximumProperty().bind(this.maximumPriceBinding);
        this.underlyingProductChoiceBox.valueProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue != null) {
                Product product = (Product)this.underlyingProductChoiceBox.getValue();
                LongDisplayValue oldPrice = this.strikePriceField.getValue();
                this.strikePriceField.setValue((oldPrice != null ? oldPrice : LongDisplayValue.ZERO).applyShift(product.getPriceDecimalShift()));
                this.strikePriceField.setDelta((int)product.getPriceTickSize().getValue());
            } else {
                LongDisplayValue oldQuantity = this.strikePriceField.getValue();
                this.strikePriceField.setValue(oldQuantity != null ? oldQuantity : LongDisplayValue.ZERO);
                this.strikePriceField.setDelta(1);
            }
        });
        this.strikePriceField.disableProperty().bind(this.optionCheckBoxField.selectedProperty().not());
    }

    private void contractTypeFieldInit() {
        this.contractTypeField.getItems().addAll((PutOrCall[])PutOrCall.values());
        this.contractTypeField.disableProperty().bind(this.optionCheckBoxField.selectedProperty().not());
        this.contractTypeField.getSelectionModel().selectFirst();
    }

    private void contractShuttleInit() {
        this.contractsShuttleSelectionField.productProperty().bind(this.underlyingProductChoiceBox.valueProperty());
        this.nameTextField.textProperty().bind(new DependentBinding<String>(new Observable[]{this.contractsShuttleSelectionField.getSelectedItems().getItems(), this.contractTypeField.valueProperty(), this.strikePriceField.valueProperty()}){

            @Override
            protected String computeValue() {
                if (BespokeContractEditorPane.this.contractsShuttleSelectionField.getSelectedItems().getItems().isEmpty()) {
                    return "";
                }
                String name = BespokeContractEditorPane.this.contractsShuttleSelectionField.getSelectedItems().getItems().stream().map(Contract::getName).collect(Collectors.joining("+"));
                Object number = "";
                if (name.length() > 64) {
                    name = name.substring(0, 64);
                    int i = 1;
                    while (BespokeContractEditorPane.this.contractQueries.findByName(name + (String)number).getFirst().isPresent()) {
                        number = "(" + i++ + ")";
                    }
                }
                String strikePrice = BespokeContractEditorPane.this.strikePriceField.getValue() != null && BespokeContractEditorPane.this.strikePriceField.getValue().compareTo(LongDisplayValue.ZERO) > 0 ? " " + String.valueOf(BespokeContractEditorPane.this.strikePriceField.getValue()) : "";
                String suffix = BespokeContractEditorPane.this.contractsShuttleSelectionField.getSelectedItems().getItems().size() == 1 ? " -" + strikePrice + " " + BespokeContractEditorPane.this.contractTypeField.getValue().name() : "";
                return name + suffix + (String)number;
            }
        });
    }

    private void underlyingProductInit() {
        this.contractsShuttleSelectionField.productProperty().bind(this.underlyingProductChoiceBox.valueProperty());
    }

    private void onSuccess(BespokeContract bespokeContract) {
        this.parent.fillContract(bespokeContract);
        this.stage.close();
    }

    private BespokeContract createBespokeContract() {
        BespokeContract bespokeContract = new BespokeContract((Product)this.underlyingProductChoiceBox.getValue(), this.contractsShuttleSelectionField.getSelectedItems().getItems().stream().map(BroadcastEntity::getId).toList(), this.contractDataModel::findById);
        bespokeContract.setName(this.nameTextField.getText());
        if (this.optionCheckBoxField.isSelected()) {
            bespokeContract.setStrikePrc(this.strikePriceField.getValue());
            bespokeContract.setPutOrCall(this.contractTypeField.getValue());
        }
        return bespokeContract;
    }

    @FXML
    public void submit() {
        BespokeContract contract = this.createBespokeContract();
        if (this.bespokeValidator.isValidBespokeContract(contract)) {
            this.bespokeService.createBespokeContract(contract, this::onSuccess);
        }
    }

    @FXML
    public void cancel() {
        this.close();
    }

    public void showPanel() {
        this.stage.setScene(new Scene(this));
        this.stage.show();
        this.stage.toFront();
    }

    private void close() {
        this.stage.close();
    }
}

