/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.entity.EntityFilters;
import com.deutscheboerse.comxerv.comtrader.domain.query.UserQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.EntityAutoCompleteField;
import com.deutscheboerse.ui.jfx.util.control.AutoCompleteTextField;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.commons.lang3.StringUtils;

public class TraderField
extends EntityAutoCompleteField<User> {
    private final UserQueries userQueries;
    private final ObjectProperty<Member> member;

    public TraderField() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public TraderField(ApplicationContext appContext) {
        super(appContext);
        this.userQueries = appContext.getService(UserQueries.class);
        this.member = new SimpleObjectProperty<Member>();
        this.setValid(false);
        this.setToStringConverter(User::getDisplayName);
    }

    @Override
    public Stream<User> getSuggestedEntities(String currentText) {
        if (this.member.get() != null) {
            return this.getDataQuery().addFilter(EntityFilters.containsIgnoreCase(this.getToStringConverter(), StringUtils.trimToEmpty(currentText))).getAll().sorted(new AutoCompleteTextField.ToStringConverterComparator(this.getToStringConverter()));
        }
        return Stream.empty();
    }

    @Override
    public Optional<User> getEntity(String currentText) {
        if (this.member.get() != null && this.getSuggestedEntities(currentText).findAny().isPresent()) {
            Optional<User> userOptional = this.getDataQuery().addFilter(EntityFilters.propertyEquals(this.getToStringConverter(), StringUtils.trimToEmpty(currentText))).getFirst();
            this.setValid(userOptional.isPresent());
            return userOptional;
        }
        this.setValid(false);
        return Optional.empty();
    }

    private DataQuery<User> getDataQuery() {
        return this.userQueries.findActiveTradersByMemberId((String)((Member)this.member.get()).getId());
    }

    public Member getMember() {
        return (Member)this.member.get();
    }

    public ObjectProperty<Member> memberProperty() {
        return this.member;
    }
}

