/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.chart;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.ContractAndMarketAreaDependentLabel;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;

public class ContractInfoLabel
extends ContractAndMarketAreaDependentLabel {
    private final InvalidationListener contractNameChangedListener = this::loadText;

    public ContractInfoLabel() {
        this.contractProperty().addListener((observable2, oldValue, newValue) -> this.contractChanged((Contract)newValue));
    }

    private void contractChanged(Contract newContract) {
        newContract.nameProperty().addListener(new WeakInvalidationListener(this.contractNameChangedListener));
        this.loadText(newContract.nameProperty());
    }

    @Override
    protected String getText(Contract contract) {
        return Util.getLabel("chartPanel_chart_title_noDA", contract.getName());
    }

    @Override
    protected String getText(Contract contract, MarketArea marketArea) {
        return Util.getLabel("chartPanel_chart_title", contract.getName(), marketArea.getName());
    }
}

