/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayImage;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DisplayNameArrowKeyBlockingChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.image.ImageFactory;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import com.deutscheboerse.ui.jfx.util.control.AutoScaleImageView;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public abstract class AbstractAreaChoiceBox<T extends BroadcastEntity<String> & DisplayImage>
extends DisplayNameArrowKeyBlockingChoiceBox<T>
implements DataModelListener<T> {
    protected final ObjectProperty<User> currentUser;
    protected final ObjectProperty<User> onBehalfUser;
    private final BooleanProperty includeDefaultNull;
    private final SmallFastDataModel<String, T> dataModel;
    private final ObjectProperty<ListedItemsMode> listedItemsMode;
    private final List<T> allAreas;
    private final ObservableObjectValue<Exchange> activeExchange;
    private final OrderPreferencesService orderPreferencesService;
    protected final AssignmentService assignmentService;
    protected final UserService userService;
    private final InvalidationListener listedItemsComputation;

    public AbstractAreaChoiceBox(ApplicationContext appContext, Class<T> areaClass) {
        this.dataModel = appContext.getSmallDataModel(areaClass);
        this.orderPreferencesService = appContext.getService(OrderPreferencesService.class);
        this.assignmentService = appContext.getService(AssignmentService.class);
        this.userService = appContext.getService(UserService.class);
        this.currentUser = new SimpleObjectProperty<User>();
        this.onBehalfUser = new SimpleObjectProperty<User>();
        this.currentUser.bind((ObservableValue<User>)new DependentBinding<User>(new Observable[]{new WeakObservableValue<User>(this.userService.currentUserProperty()), this.onBehalfUser}){

            @Override
            protected User computeValue() {
                return Optional.ofNullable((User)AbstractAreaChoiceBox.this.onBehalfUser.get()).orElse((User)AbstractAreaChoiceBox.this.userService.currentUserProperty().get());
            }
        });
        this.includeDefaultNull = new SimpleBooleanProperty(false);
        this.listedItemsMode = new SimpleObjectProperty<ListedItemsMode>(ListedItemsMode.MANUAL);
        this.allAreas = new CopyOnWriteArrayList<T>();
        StyleUtil.addStyleClass(this, "deliveryAreaChoiceBox");
        this.listedItemsComputation = observable2 -> this.recomputeListedItems();
        this.activeExchange = appContext.getService(ActiveExchange.class).getActiveExchange();
        this.activeExchange.addListener(new WeakInvalidationListener(this.listedItemsComputation));
        this.listedItemsMode.addListener(this.listedItemsComputation);
        this.includeDefaultNull.addListener(this.listedItemsComputation);
        this.currentUser.addListener(this.listedItemsComputation);
        this.dataModel.registerListener(new WeakDataModelListener(this));
    }

    @Override
    protected Node createGraphic(T value) {
        return new AutoScaleImageView(ImageFactory.getImage((DisplayImage)value, "/com/deutscheboerse/comxerv/comtrader/flags/64x64/00_default.png"), this);
    }

    public void applyDefaultValue() {
        T defaultValue = this.getDefaultValue(this.orderPreferencesService.getDefaultDeliveryArea());
        List listedItems = this.getListedItems();
        if (defaultValue != null && listedItems.contains(defaultValue)) {
            this.setValue(defaultValue);
        } else if (!listedItems.isEmpty()) {
            this.setValue((BroadcastEntity)listedItems.get(0));
        }
    }

    protected abstract T getDefaultValue(DeliveryArea var1);

    protected void recomputeListedItems() {
        HashSet<Object> newListedItems = new HashSet<Object>();
        if (this.isIncludeDefaultNull()) {
            newListedItems.add(null);
        }
        switch (this.getListedItemsMode().ordinal()) {
            case 3: {
                return;
            }
            case 1: {
                this.allAreas.stream().filter(x$0 -> this.isAnOption((BroadcastEntity)x$0)).forEach(x$0 -> newListedItems.add(x$0));
                break;
            }
            case 2: {
                this.allAreas.stream().filter(x$0 -> this.isMineOption((BroadcastEntity)x$0)).forEach(x$0 -> newListedItems.add(x$0));
                break;
            }
            case 0: {
                this.allAreas.stream().forEach(x$0 -> newListedItems.add(x$0));
            }
        }
        this.setListedItems(newListedItems);
    }

    @Override
    public boolean setListedItems(Collection<T> listedItems) {
        TreeSet<DisplayName> listedItemsSorted = new TreeSet<DisplayName>(DisplayName.comparator());
        listedItemsSorted.addAll(listedItems);
        return super.setListedItems(listedItemsSorted);
    }

    abstract boolean isAnOption(T var1);

    abstract boolean isMineOption(T var1);

    @Override
    public DataModelListener.NotificationResult notifyAdd(T object) {
        this.allAreas.add(object);
        this.recomputeListedItems();
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyAddAll(Collection<T> objects) {
        this.allAreas.addAll(objects);
        this.recomputeListedItems();
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemove(T object) {
        this.allAreas.remove(object);
        this.recomputeListedItems();
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll(Collection<T> objects) {
        this.allAreas.removeAll(objects);
        this.recomputeListedItems();
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdate(T object) {
        this.allAreas.remove(object);
        this.allAreas.add(object);
        this.recomputeListedItems();
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdateAll(Collection<T> objects) {
        this.allAreas.removeAll(objects);
        this.allAreas.addAll(objects);
        this.recomputeListedItems();
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll() {
        this.allAreas.clear();
        this.recomputeListedItems();
        return DataModelListener.NotificationResult.REMOVE_LISTENER;
    }

    public void setValueFromId(String daId) {
        this.getListedItems().stream().filter(da -> da != null && ((String)da.getId()).equals(daId)).findFirst().ifPresent(x$0 -> this.setValue(x$0));
    }

    public ObjectProperty<User> onBehalfUserProperty() {
        return this.onBehalfUser;
    }

    public boolean isIncludeDefaultNull() {
        return this.includeDefaultNull.get();
    }

    public void setIncludeDefaultNull(boolean includeDefaultNull) {
        this.includeDefaultNull.set(includeDefaultNull);
    }

    public BooleanProperty includeDefaultNullProperty() {
        return this.includeDefaultNull;
    }

    public ListedItemsMode getListedItemsMode() {
        return (ListedItemsMode)((Object)this.listedItemsMode.get());
    }

    public void setListedItemsMode(ListedItemsMode listedItemsMode) {
        this.listedItemsMode.set(listedItemsMode);
    }

    public ObjectProperty<ListedItemsMode> listedItemsModeProperty() {
        return this.listedItemsMode;
    }

    public static enum ListedItemsMode {
        ALL_AVAILABLE,
        ALL_ACTIVE,
        ALL_MINE,
        MANUAL;

    }
}

