/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.StorableBottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.ValidProperty;
import java.math.BigDecimal;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public abstract class AbstractLongDisplayValueField
extends BorderPane
implements StorableBottomToolbarNode<LongDisplayValue> {
    private final ObjectProperty<LongDisplayValue> value;
    private final IntegerProperty delta;
    private final TextField textField;
    private final BorderPane upButton;
    private final BorderPane downButton;
    private final VBox buttonsContainer;
    private final ObjectProperty<LongDisplayValue> maximum;
    private final ObjectProperty<LongDisplayValue> minimum;
    private final ValidProperty valid;
    private final BooleanProperty validMinMax;
    private final BooleanProperty validChange;
    private final BooleanProperty allowEmptyField;
    private final ObjectProperty<String> promptText;
    private String description;

    public AbstractLongDisplayValueField() {
        this((LongDisplayValue)null);
    }

    public AbstractLongDisplayValueField(LongDisplayValue initialValue) {
        this(initialValue, 1);
    }

    public AbstractLongDisplayValueField(LongDisplayValue initialValue, int delta) {
        this.value = new SimpleObjectProperty<LongDisplayValue>(initialValue);
        this.delta = new SimpleIntegerProperty(delta);
        this.allowEmptyField = new SimpleBooleanProperty(false);
        this.maximum = new SimpleObjectProperty<LongDisplayValue>(initialValue != null ? new LongDisplayValue(Integer.MAX_VALUE, initialValue.getShift()) : null);
        this.minimum = new SimpleObjectProperty<LongDisplayValue>(initialValue != null ? new LongDisplayValue(Integer.MIN_VALUE, initialValue.getShift()) : null);
        this.promptText = new SimpleObjectProperty<String>();
        this.textField = new TextField(initialValue != null ? initialValue.toString() : "");
        this.valid = new ValidProperty(this.textField);
        this.validMinMax = new SimpleBooleanProperty(true);
        this.validChange = new SimpleBooleanProperty(true);
        this.valid.bind(this.validMinMax.and(this.validChange));
        InvalidationListener valueMinMaxListener = observable2 -> this.setValidFromMinMax();
        this.allowEmptyField.addListener(valueMinMaxListener);
        this.value.addListener(valueMinMaxListener);
        this.minimum.addListener(valueMinMaxListener);
        this.maximum.addListener(valueMinMaxListener);
        this.disableProperty().addListener(valueMinMaxListener);
        this.upButton = new BorderPane();
        this.upButton.setCenter(new Text("\u25b2"));
        this.downButton = new BorderPane();
        this.downButton.setCenter(new Text("\u25bc"));
        this.buttonsContainer = new VBox();
        this.textField.promptTextProperty().bind(this.promptText);
        this.textField.textProperty().addListener((paramObservableValue, oldTextValue, newTextValue) -> this.textChanged((String)newTextValue));
        this.value.addListener((observable2, oldValue, newValue) -> {
            if (!this.textField.isFocused()) {
                this.textField.setText(this.toString((LongDisplayValue)newValue));
            }
        });
        this.textField.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (!oldValue.booleanValue() && newValue.booleanValue()) {
                this.selectAllIfFocused();
            }
            if (oldValue.booleanValue() && !newValue.booleanValue() && !this.isValid()) {
                this.setValue(null);
            }
        });
        this.textField.setOnScroll(this::handleOnScrollEvent);
        this.textField.addEventFilter(KeyEvent.KEY_PRESSED, this::handleKeyPressedEvent);
        this.textField.setAlignment(Pos.CENTER_RIGHT);
        DoubleBinding buttonHeight = this.textField.heightProperty().divide(2);
        this.upButton.prefHeightProperty().bind(buttonHeight);
        this.upButton.minHeightProperty().bind(buttonHeight);
        this.upButton.maxHeightProperty().bind(buttonHeight);
        this.downButton.prefHeightProperty().bind(buttonHeight);
        this.downButton.minHeightProperty().bind(buttonHeight);
        this.downButton.maxHeightProperty().bind(buttonHeight);
        this.setCenter(this.textField);
        this.setRight(this.buttonsContainer);
        this.buttonsContainer.getChildren().addAll((Node[])new Node[]{this.upButton, this.downButton});
        BorderPane.setAlignment(this.buttonsContainer, Pos.CENTER_LEFT);
        this.buttonsContainer.setAlignment(Pos.CENTER_LEFT);
        StyleUtil.addStyleClass(this, "simpleLongDisplayValueField");
        StyleUtil.addStyleClass(this.textField, "valueField");
        StyleUtil.addStyleClass(this.upButton, "upButton");
        StyleUtil.addStyleClass(this.upButton, "sldvfButton");
        StyleUtil.addStyleClass(this.downButton, "downButton");
        StyleUtil.addStyleClass(this.downButton, "sldvfButton");
        this.upButton.setOnMouseClicked(mouseEvent -> {
            this.requestTextFieldFocus();
            this.increment(this.getMultiplier((MouseEvent)mouseEvent));
            mouseEvent.consume();
        });
        this.downButton.setOnMouseClicked(mouseEvent -> {
            this.requestTextFieldFocus();
            this.decrement(this.getMultiplier((MouseEvent)mouseEvent));
            mouseEvent.consume();
        });
    }

    private void handleKeyPressedEvent(KeyEvent keyEvent) {
        int multiplier = 1;
        if (keyEvent.isControlDown()) {
            multiplier = 10;
        } else if (keyEvent.isAltDown()) {
            multiplier = 100;
        } else if (keyEvent.isShiftDown()) {
            multiplier = 1000;
        }
        if (keyEvent.getCode() == KeyCode.UP) {
            this.increment(multiplier);
            keyEvent.consume();
        } else if (keyEvent.getCode() == KeyCode.DOWN) {
            this.decrement(multiplier);
            keyEvent.consume();
        }
    }

    private void handleOnScrollEvent(ScrollEvent scrollEvent) {
        this.requestTextFieldFocus();
        int multiplier = 1;
        if (scrollEvent.isControlDown()) {
            multiplier = 10;
        } else if (scrollEvent.isAltDown()) {
            multiplier = 100;
        } else if (scrollEvent.isShiftDown()) {
            multiplier = 1000;
        }
        if (this.isScrollUp(scrollEvent)) {
            this.increment(multiplier);
        } else if (this.isScrollDown(scrollEvent)) {
            this.decrement(multiplier);
        }
    }

    private void textChanged(String newTextValue) {
        block6: {
            this.validChange.set(true);
            try {
                if (!(newTextValue == null || newTextValue.isEmpty() && this.allowEmptyField.get())) {
                    BigDecimal convertedValue = Util.parse(newTextValue);
                    LongDisplayValue roundedValue = this.getRoundedValue(convertedValue);
                    if (convertedValue.scale() > roundedValue.getShift() && convertedValue.compareTo(roundedValue.getDisplayValue()) != 0) {
                        this.validChange.set(false);
                        this.value.setValue(null);
                    } else {
                        this.value.setValue(roundedValue);
                    }
                } else {
                    this.value.setValue(null);
                }
            }
            catch (NumberFormatException e) {
                if (newTextValue != null && newTextValue.isEmpty() && this.getAllowEmptyField()) break block6;
                this.value.setValue(null);
                this.validChange.set(false);
            }
        }
    }

    private LongDisplayValue getRoundedValue(BigDecimal convertedValue) {
        LongDisplayValue minimumToUseForRounding = this.getMinimum() != null ? this.getMinimum() : LongDisplayValue.ZERO;
        LongDisplayValue valueToUseForRounding = this.getValue() != null ? this.getValue() : minimumToUseForRounding;
        return valueToUseForRounding.setRoundedValue(convertedValue);
    }

    private void setValidFromMinMax() {
        if (this.value.get() == null && !this.disableProperty().get() && !this.getAllowEmptyField() || this.value.get() != null && this.minimum.get() != null && this.deltaProperty().get() != 0 && (((LongDisplayValue)this.value.get()).compareTo((LongDisplayValue)this.minimum.get()) < 0 || this.maximum.get() != null && ((LongDisplayValue)this.value.get()).compareTo((LongDisplayValue)this.maximum.get()) > 0 || ((LongDisplayValue)this.value.get()).getValue() % (long)this.delta.get() != 0L)) {
            this.validMinMax.setValue(false);
        } else {
            this.validMinMax.setValue(true);
        }
    }

    private boolean isScrollUp(ScrollEvent scrollEvent) {
        return scrollEvent.getDeltaY() > 0.0 || SystemUtils.IS_OS_WINDOWS && scrollEvent.getDeltaX() > 0.0 && scrollEvent.isShiftDown();
    }

    private boolean isScrollDown(ScrollEvent scrollEvent) {
        return scrollEvent.getDeltaY() < 0.0 || SystemUtils.IS_OS_WINDOWS && scrollEvent.getDeltaX() < 0.0 && scrollEvent.isShiftDown();
    }

    private void requestTextFieldFocus() {
        if (!this.textField.isFocused()) {
            this.textField.requestFocus();
        }
    }

    private String toString(LongDisplayValue value) {
        return value == null ? null : Util.format(value.getDisplayValue());
    }

    private long getMultiplier(MouseEvent mouseEvent) {
        long multiplier = 1L;
        if (mouseEvent.isControlDown()) {
            multiplier = 10L;
        } else if (mouseEvent.isAltDown()) {
            multiplier = 100L;
        } else if (mouseEvent.isShiftDown()) {
            multiplier = 1000L;
        }
        return multiplier;
    }

    public abstract LongDisplayValue getInitialValue();

    public void increment(long multiplier) {
        if (this.getValue() == null) {
            this.setValue(this.getInitialValue());
        }
        long currentValue = this.getValue().getValue();
        long extra = currentValue % (long)this.delta.get();
        LongDisplayValue newValue = currentValue > 0L ? this.getValue().add((long)this.delta.get() * multiplier - extra) : (extra == 0L ? this.getValue().add((long)this.delta.getValue().intValue() * multiplier) : this.getValue().add(-extra));
        if (this.getMaximum() != null && newValue.compareTo(this.getMaximum()) > 0) {
            newValue = this.getMaximum();
        }
        if (this.getMinimum() != null && newValue.compareTo(this.getMinimum()) < 0) {
            newValue = this.getMinimum();
        }
        this.setValue(newValue);
        this.selectAllIfFocused();
    }

    public void decrement(long multiplier) {
        if (this.getValue() == null) {
            this.setValue(this.getInitialValue());
        }
        long currentValue = this.getValue().getValue();
        long extra = currentValue % (long)this.delta.get();
        LongDisplayValue newValue = currentValue > 0L && extra != 0L ? this.getValue().subtract(extra) : (extra == 0L ? this.getValue().subtract((long)this.delta.getValue().intValue() * multiplier) : this.getValue().subtract((long)this.delta.getValue().intValue() * multiplier + extra));
        if (this.getMaximum() != null && newValue.compareTo(this.getMaximum()) > 0) {
            newValue = this.getMaximum();
        }
        if (this.getMinimum() != null && newValue.compareTo(this.getMinimum()) < 0) {
            newValue = this.getMinimum();
        }
        this.setValue(newValue);
        this.selectAllIfFocused();
    }

    protected void selectAllIfFocused() {
        if (this.textField.isFocused() && !StringUtils.isEmpty(this.textField.getText())) {
            FxUtil.runLater(this.textField::selectAll);
        }
    }

    public ObjectProperty<LongDisplayValue> valueProperty() {
        return this.value;
    }

    public LongDisplayValue getValue() {
        return (LongDisplayValue)this.value.get();
    }

    public void setValue(LongDisplayValue value) {
        this.value.set(value);
        this.textField.setText(this.toString(value));
    }

    public int getDelta() {
        return this.delta.get();
    }

    public void setDelta(int delta) {
        this.delta.set(delta);
    }

    public IntegerProperty deltaProperty() {
        return this.delta;
    }

    public Node getTextField() {
        return this.textField;
    }

    public ReadOnlyBooleanProperty validProperty() {
        return this.valid;
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public LongDisplayValue getMinimum() {
        return (LongDisplayValue)this.minimum.get();
    }

    public void setMinimum(LongDisplayValue minimum) {
        this.minimum.set(minimum);
    }

    public ObjectProperty<LongDisplayValue> minimumProperty() {
        return this.minimum;
    }

    public LongDisplayValue getMaximum() {
        return (LongDisplayValue)this.maximum.get();
    }

    public void setMaximum(LongDisplayValue maximum) {
        this.maximum.set(maximum);
    }

    public ObjectProperty<LongDisplayValue> maximumProperty() {
        return this.maximum;
    }

    public String getPromptText() {
        return (String)this.promptText.get();
    }

    public ObjectProperty<String> promptTextProperty() {
        return this.promptText;
    }

    public void setPromptText(String promptText) {
        this.promptText.set(promptText);
    }

    public ReadOnlyBooleanProperty textFieldFocusedProperty() {
        return this.textField.focusedProperty();
    }

    public boolean getAllowEmptyField() {
        return this.allowEmptyField.get();
    }

    public BooleanProperty allowEmptyFieldProperty() {
        return this.allowEmptyField;
    }

    public void setAllowEmptyField(boolean allowEmptyField) {
        this.allowEmptyField.set(allowEmptyField);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public LongDisplayValue getState() {
        return this.getValue();
    }

    @Override
    public void restoreSavedState(LongDisplayValue state) {
        this.setValue(state);
    }
}

