/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.ProductQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.EntityAutoCompleteField;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.commons.lang3.StringUtils;

public class ProductField
extends EntityAutoCompleteField<Product> {
    private final ProductQueries productQueries;
    private final UserService userService;
    private final AssignmentService assignmentService;
    private final ObjectProperty<Product> product;
    private final Predicate<Product> productFilter = Product::isOnExchangePrearrangedTrade;
    private final ObjectProperty<Mode> mode = new SimpleObjectProperty<Mode>(Mode.ALL);
    private final BooleanProperty allowEmpty = new SimpleBooleanProperty(false);
    private final BooleanProperty assignedOnly = new SimpleBooleanProperty(false);

    public ProductField() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public ProductField(ApplicationContext appContext) {
        super(appContext);
        this.product = new SimpleObjectProperty<Product>();
        this.productQueries = appContext.getService(ProductQueries.class);
        this.userService = appContext.getService(UserService.class);
        this.assignmentService = appContext.getService(AssignmentService.class);
        StyleUtil.addStyleClass(this, "contractField");
        this.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (!oldValue.booleanValue() && newValue.booleanValue()) {
                FxUtil.runInFxThread(() -> {
                    if (this.isFocused() && !StringUtils.isEmpty(this.getText())) {
                        this.selectAll();
                    }
                });
            }
            this.setValidationErrorStyleIfNeeded(Optional.ofNullable((Product)this.getValue()));
        });
        this.setToStringConverter(Product::getDisplayName);
    }

    @Override
    public Stream<Product> getSuggestedEntities(String currentText) {
        if (this.getMode() == Mode.ALL || this.getProduct() != null) {
            return this.getProductDataQuery(currentText);
        }
        return Stream.empty();
    }

    private Stream<Product> getProductDataQuery(String currentText) {
        return this.productQueries.findActiveProductsByNameContains(StringUtils.stripToEmpty(currentText)).addFilter(this.productFilter).addFilter(this::isAssigned).getAll().sorted(Product.DEFAULT_DISPLAY_COMPARATOR);
    }

    @Override
    public Optional<Product> getEntity(String currentText) {
        Optional<Product> product = currentText != null && !currentText.isEmpty() && this.getSuggestedEntities(currentText).findAny().isPresent() ? this.productQueries.findActiveProductsByName(StringUtils.stripToEmpty(currentText)).addFilter(this.productFilter).addFilter(this::isAssigned).getFirst() : Optional.empty();
        this.setValidationErrorStyleIfNeeded(product);
        return product;
    }

    private boolean isAssigned(Product product) {
        if (!this.getAssignedOnly()) {
            return true;
        }
        if (product != null) {
            User user = this.userService.getCurrentUser();
            return this.assignmentService.getProductIds(user).contains(product.getId());
        }
        return false;
    }

    private void setValidationErrorStyleIfNeeded(Optional<Product> product) {
        this.setValid(product.isPresent() || this.isAllowEmpty());
    }

    public Product getProduct() {
        return (Product)this.product.get();
    }

    public ObjectProperty<Product> productProperty() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product.set(product);
    }

    public Mode getMode() {
        return (Mode)((Object)this.mode.get());
    }

    public ObjectProperty<Mode> modeProperty() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode.set(mode);
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty.get();
    }

    public BooleanProperty allowEmptyProperty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty.set(allowEmpty);
    }

    public boolean getAssignedOnly() {
        return this.assignedOnly.get();
    }

    public BooleanProperty assignedOnlyProperty() {
        return this.assignedOnly;
    }

    public void setAssignedOnly(boolean assignedOnly) {
        this.assignedOnly.set(assignedOnly);
    }

    public static enum Mode {
        ALL,
        PRODUCT_SPECIFIC;

    }
}

